/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.sync;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.text.Document;

import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

import org.netbeans.modules.xml.core.*;
import org.netbeans.modules.xml.core.cookies.*;

/**
 * Simple representations manager. It handles mutual exclusivity of File and
 * Text representations because of possible problems with modified status and
 * save cookie management.
 * <p>
 * It also always adds Text representation if Tree representation was required.
 * This is workaround adding undo feature to tree operations via text undo.
 * Also only Text representation needs to take care about modifications and save().
 *
 * @author  Petr Kuzel
 * @version 
 */
public class DataObjectSyncSupport extends SyncSupport implements Synchronizator {
    
    private final Vector reps;
        
    private final CookieManagerCookie cookieMgr;

    
    /** Creates new DataObjectSyncSupport */
    public DataObjectSyncSupport(XMLDataObjectLook dobj) {
        super((DataObject)dobj);
        reps = new Vector(3);
        cookieMgr = dobj.getCookieManager();

        Representation basic = new FileRepresentation (getDO(), this);
        reps.add(basic);
    }


    public void representationChanged(Class type) {
        super.representationChanged(type);
    }
    
    /*
     * Return conditional set of representations.
     *
     */
    protected Representation[] getRepresentations() {
        return (Representation[]) reps.toArray(new Representation[0]);
    }

    /**
     * Select from loaded representation proper one that can be used as primary.
     */
    public Representation getPrimaryRepresentation() {
        
        final Class priority[] = new Class[] {  //??? it should be provided by protected method
            Document.class, 
//              TreeDocumentRoot.class,
            FileObject.class
        };
        
        Representation all[] = getRepresentations();
        
        for (int i = 0; i<priority.length; i++) {
            for (int r = 0; r<all.length; r++) {
                Representation rep = all[r];
                if (rep.isValid() == false) 
                    continue;
                if (rep.represents(priority[i])) {
                    if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("Primary rep = " + rep); // NOI18N

                    return rep;
                }
            }
        }
        
        throw new IllegalStateException("No primary representation found: " + reps); // NOI18N
    }
    
    /*
     * Manipulate appropriare cookies at data object.
     * Keep text and file rpresentation as mutually exclusive.
     */
    public void addRepresentation(Representation rep) {
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("Sync addRepresentation " + rep); // NOI18N

        if (rep.represents(Document.class)) {
            for (Iterator it = reps.iterator(); it.hasNext();) {
                Representation next = (Representation) it.next();
                if (next.represents(FileObject.class)) {
                    it.remove();
                }                               
            }
        } else if (rep.level() > 1) {
            
            // load also text representation, tree cannot live without it
            
            loadTextRepresentation();
        }
        reps.add(rep);
    }

    

    /*
     * Manipulate appropriare cookies at data object.
     * Keep text and file rpresentation as mutually exclusive.
     */    
    public void removeRepresentation(Representation rep) {
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("Sync removeRepresentation " + rep); // NOI18N
        
        boolean modelLoaded = false;

        if (rep.represents(Document.class)) {
            
            // check whether tree representation is loaded
            

            for (Iterator it = reps.iterator(); it.hasNext();) {
                Representation next = (Representation) it.next();
                if (next.level() > 1) {
                    modelLoaded = true;
                }                               
            }

            if (modelLoaded == false) {
            
                Representation basic = new FileRepresentation (getDO(), this);
                reps.add(basic);
            
            } else {     
                
                // reload text representation, tree cannot live without it

                loadTextRepresentation();
            }
        }                        
        reps.remove(rep);

        if ( modelLoaded ) {//&& ( getDO().isValid() ) ) {
            representationChanged (Document.class);
        }
    }

    
    private void loadTextRepresentation() {
        if ( getDO().isValid() ) { // because of remove modified document
            try {
                EditorCookie editor = (EditorCookie) getDO().getCookie(EditorCookie.class);
                editor.openDocument();
            } catch (IOException ex) {
                //??? ignore it just now
            }
        }
    }
}
