/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.wizard;

import java.util.*;
import java.beans.*;

import javax.swing.*;
import javax.swing.event.*;

import org.openide.*;
import org.openide.util.HelpCtx;
import java.net.URL;

/**
 * Base class of wizardable panels. <code>updateModel</code>
 * and <code>initView</code> methods need to be implemented. They are called as user goes 
 * over wizard steps and it must (re)store current state.
 * <p>
 * For proper functionality it must be wrapped by {@link WizardStep}.
 *
 * @author  Petr Kuzel
 * @version 
 */
public abstract class AbstractPanel extends JPanel implements Customizer {

    /** Serial Version UID */
    private static final long serialVersionUID =508989667995691L;
    
    /**
     * After a setObject() call contains current model driving wizard.
     */
    protected DocumentModel model;

    // associated wizard step wrapper (initialized by step.    
    private WizardStep step;
            
    /**
     * User just leaved the panel, update model
     */
    protected abstract void updateModel();
    
    /**
     * User just entered the panel, init view by model values
     */
    protected abstract void initView();
    
    /**
     * User just reentered the panel.
     */
    protected abstract void updateView();
    
    
    
    // customizer impl ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    public void setObject(Object model) {
        if ( not(model instanceof DocumentModel) ) {
            throw new IllegalArgumentException("DocumentModel class expected.");  // NOI18N
        }        
        
        this.model = (DocumentModel) model;
        initView();
    }    
        
    public void addPropertyChangeListener(PropertyChangeListener p1) {
    }
    
    public void removePropertyChangeListener(PropertyChangeListener p1) {
    }

    protected static boolean not(boolean expr) {
        return ! expr;
    }

    /**
     * Gives access to WizardStep wrapper.
     * It is supported only for AbstractPanel with associated WizardStep.
     * @return step or <code>IllegalStateException</code> exception.
     */
    protected final WizardStep getStep() {
        if (step == null) throw new IllegalStateException("new WizardStep(this) have not been called!");
        return step;
    }
    
    /**
     * WizardDescriptor.Panel adapter for AbstractPanel.
     * It solved isValid() clash between Component and WizardDescriptor.Panel.
     */
    public static class WizardStep implements WizardDescriptor.Panel {
        
        private final AbstractPanel peer;
        private Vector listeners = new Vector(); 
        private final ChangeEvent EVENT = new ChangeEvent(this);
        private boolean valid = true;
        
        public WizardStep(AbstractPanel peer) {
            if (peer == null) throw new NullPointerException();
            this.peer = peer;
            peer.step = this;
        }
    
        public java.awt.Component getComponent() {
            return peer;
        }

        public void readSettings(Object settings) {
            peer.updateView();
        }

        /**
         * Cunstruct help ctx from WizardPanel_helpURL property.
         */
        public final HelpCtx getHelp() {
    //        URL url = (URL) getClientProperty("WizardPanel_helpURL");
    //        if (url != null) {
    //            return new HelpCtx(peer.getClass());  // warning getClass(0 returns a subclass
    //        }
            return HelpCtx.DEFAULT_HELP;
        }
    
        public void addChangeListener(javax.swing.event.ChangeListener l) {
            listeners.add(l);
        }

        public void storeSettings(Object settings) {
            peer.updateModel();
        }

        public boolean isValid() {
            return valid;
        }

        protected final void setValid(boolean valid) {

            if (this.valid == valid) return;

            this.valid = valid;

            synchronized (listeners) {
                Iterator it = listeners.iterator();
                while (it.hasNext()) {
                    ChangeListener next = (ChangeListener) it.next();
                    next.stateChanged(EVENT);
                }
            }
        }

        public void removeChangeListener(ChangeListener l) {
            listeners.remove(l);
        }
    }
    
}
