/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.core.wizard;

import java.io.*;
import java.util.*;

import org.xml.sax.*;
import org.xml.sax.ext.*;
import org.xml.sax.helpers.*;

import org.openide.xml.*;
import org.openide.util.Lookup;

import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.api.xml.parsers.SAXEntityParser;

/**
 * Silently produces Set<String> of roots from passed SAX declaration handler events.
 *
 * @author  Petr Kuzel
 */
final class DTDParser extends DefaultHandler implements DeclHandler {

    static final String SAX_PROPERTY = "http://xml.org/sax/properties/";        // NOI18N
    static final String DECL_HANDLER = "declaration-handler";                   // NOI18N
    
    private final Set roots = new TreeSet();
            
    /** Creates new DTDParser */
    public DTDParser() {
    }

    /**
     * @param in if filled only SID and PID the entity catalog "normalization" is used
     */
    public Set parse(InputSource in) {

        Util.THIS.debug("DTDParser started.");
                
        try {
            // we do not want Crimson, it does not understand relative SYSTEM ids
            XMLReader parser = XMLUtil.createXMLReader(true);   
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            parser.setProperty(SAX_PROPERTY + DECL_HANDLER, this);
            
            // provide fake entity resolver and source
            
            UserCatalog catalog = UserCatalog.getDefault();
            EntityResolver res = (catalog == null ? null : catalog.getEntityResolver());
            
            if (res != null) parser.setEntityResolver(res);
            
            SAXEntityParser dtdParser = new SAXEntityParser(parser, false);
            dtdParser.parse(in);
            
            throw new IllegalStateException("How we can get here?");            // NOI18N
        } catch (Stop stop) {
            return roots;  // expected
        } catch (SAXException ex) {
            Util.THIS.debug("Ignoring SAX ex. while parsing DTD:", ex);         // NOI18N
            if (ex.getException() instanceof RuntimeException) {
                Util.THIS.debug("Nested exception:", ex.getException());        // NOI18N
            }            
            return roots;  // better partial result than nothing
        } catch (IOException ex) {
            Util.THIS.debug("Ignoring I/O ex. while parsing DTD:", ex);         // NOI18N
            return roots;  // better partial result than nothing
        } finally {
            Util.THIS.debug("DTDParser stopped.");                              // NOI18N
        }
    }
            
    public void elementDecl(String name, String model) throws SAXException {
        Util.THIS.debug("\telementDecl(" + name + ",...)");                     // NOI18N
        roots.add(name);
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void notationDecl (String name, String publicId, String systemId) throws SAXException {
    }                

    public void startElement (String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Util.THIS.debug("\tstopping parser!");                                  // NOI18N
        throw new Stop();
    }

    private class Stop extends SAXException {
        
        private static final long serialVersionUID = -64662796017444980L;
        
        Stop() {
            super("STOP");                                                      //NOI18N
        }
        
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}
