/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

import org.openide.NotifyDescriptor;
import org.openide.DialogDisplayer;
import org.openide.actions.ActionManager;
import org.openide.windows.WindowManager;

import org.netbeans.api.xml.services.UserCatalog;

import org.netbeans.modules.xml.core.lib.AbstractUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

/**
 * Collection of static support methods.
 *
 * @author Petr Kuzel
 */
class Util extends AbstractUtil {

    // last catalog directory
    private static File lastDirectory;
    
    /** Default and only one instance of this class. */
    public static final Util THIS = new Util();

    /** Nobody can create instance of it, just me. */
    private Util () {
    }
    
    /**
     * Prompts user for a Schema file.
     * @param extensions a space separated list of file extensions
     * @return filename or null if operation was cancelled.
     */
    public static File selectSchemaFile(final String extensions) {
        JFileChooser chooser = new JFileChooser();

        chooser.setFileFilter(new FileFilter() {
            public boolean accept(File f) {
                if (f.isDirectory()) return true;
                StringTokenizer token = new StringTokenizer(extensions, " ");  // NOI18N
                while (token.hasMoreElements()) {
                    if (f.getName().endsWith(token.nextToken())) return true;
                }
                return false;
            }
            public String getDescription() {
                return Util.THIS.getString("PROP_schema_mask"); // NOI18N
            }
        });

        if (lastDirectory != null) {
            chooser.setCurrentDirectory(lastDirectory);
        }

        chooser.setDialogTitle(Util.THIS.getString("PROP_schema_dialog_name"));
        while (chooser.showDialog(WindowManager.getDefault().getMainWindow(),
                               Util.THIS.getString("PROP_schema_select_button"))
               == JFileChooser.APPROVE_OPTION)
        {
            File f = chooser.getSelectedFile();
            lastDirectory = chooser.getCurrentDirectory();
            if (f != null && f.isFile()) {
                StringTokenizer token = new StringTokenizer(extensions, " ");  // NOI18N
                while (token.hasMoreElements()) {
                    if (f.getName().endsWith(token.nextToken())) return f;
                }
                     }

            DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(
                Util.THIS.getString("MSG_inValidFile"), NotifyDescriptor.WARNING_MESSAGE));
        }
        return null;
    }    
    
    /**
     * Obtain all known DTD public IDs.
     */
    public static String[] getKnownDTDPublicIDs() {
        UserCatalog catalog = UserCatalog.getDefault();
        if (catalog != null) {
            Set idSet = new TreeSet();
            for (Iterator it = catalog.getPublicIDs(); it.hasNext(); ) {
                String next = (String) it.next();
                // exclude schema publicIDs
                String nextLowerCase = next.toLowerCase();
                if (!nextLowerCase.startsWith("schema:") && !nextLowerCase.endsWith(".xsd")) { // NOI18N
                    idSet.add(next);
                }
            }
            return (String[]) idSet.toArray(new String[idSet.size()]);
        } else {
            Util.THIS.debug("Note SourceResolver not found!");            // NOI18N
            return new String[0];
        }        
    }    
    
    /**
     * Perform default action on specified data object.
     */
    public static void performDefaultAction (DataObject dataObject) {

        Node node = dataObject.getNodeDelegate();
        SystemAction action = node.getDefaultAction();

        if (action != null) {
            ActionManager manager = (ActionManager) Lookup.getDefault().lookup(ActionManager.class);
            manager.invokeAction(action, new ActionEvent (node, ActionEvent.ACTION_PERFORMED, "")); // NOI18N
        }
    }
    
}
