/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core;

import junit.textui.TestRunner;
import org.netbeans.jellytools.Bundle;
import org.netbeans.tests.xml.AbstractTemplatesTest;
import org.netbeans.tests.xml.AbstractTestUtil;

/**
 * <P>
 * <P>
 * <FONT COLOR="#CC3333" FACE="Courier New, Monospaced" SIZE="+1">
 * <B>
 * <BR> XML Module Jemmy Test: NewFromTemplate
 * </B>
 * </FONT>
 * <BR><BR><B>What it tests:</B><BR>
 *
 * This test tests New From Template action on all XML's templates.
 *
 * <BR><BR><B>How it works:</B><BR>
 *
 * 1) create new documents from template<BR>
 * 2) write the created documents to output<BR>
 * 3) close source editor<BR>
 *
 * <BR><BR><B>Settings:</B><BR>
 * none<BR>
 *
 * <BR><BR><B>Output (Golden file):</B><BR>
 * Set XML documents.<BR>
 *
 * <BR><B>To Do:</B><BR>
 * none<BR>
 *
 * <P>Created on Januar 09, 2001, 12:33 PM
 * <P>
 */

public class CoreTemplatesTest extends AbstractTemplatesTest {
    /** Creates new CoreTemplatesTest */
    public CoreTemplatesTest(String testName) {
        super(testName);
    }
    
    protected String[][] getTemplateList() {
        return new String [][] {
            {Bundle.getString(CORE_BUNDLE, "Templates/XML/emptyDTD.dtd"), "dtd"},
            {Bundle.getString(CORE_BUNDLE, "Templates/XML/StyleSheet.xsl"), "xsl"},
            {Bundle.getString(CORE_BUNDLE, "Templates/XML/xml_entity.ent"), "ent"},
        };
    }
    
    protected AbstractTestUtil testUtil() {
        return TestUtil.THIS;
    }
    
    public static void main(String[] args) {
        //JamController.setFast(true);
        DEBUG = true;
        TestRunner.run(CoreTemplatesTest.class);
    }
}
