/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.settings;

import junit.textui.TestRunner;
import org.openide.options.SystemOption;
import org.netbeans.tests.xml.XTest;

/**
 * ToDo Check:
 * Options > Editing > XML > * settings
 * Options > Editing > Editor Settings > (DTD, XML, CSS) Editor settings
 * Options > Editing > Indentation Engine settings
 * Options > IDE Configuration > Look and Feel > Actions > XML
 * Options > IDE Configuration > Menu Bar > Help > Help Sets > XML support ???
 * Options > System > Object Types >  (DTD, CSS, XML)
 * Options > Source Creation and Management > Templaes > XML & DTD > * ???
 * @author  ms113234
 *
 */
public class CoreSettingsTest extends XTest {
    private static final String CORE_SETTINGS = "org.netbeans.modules.xml.core.settings.CoreSettings";
    
    /** Creates new CoreSettingsTest */
    public CoreSettingsTest(String testName) {
        super(testName);
    }
    
    public void testSystemOptions() throws Exception {
        SystemOptionTest test = new SystemOptionTest();
        ref(test.testSystemOption(CORE_SETTINGS));
        compareReferenceFiles();
    }
    
    public void testDefaultSettings() throws Exception {
        // get option
        Class clazz = Class.forName(CORE_SETTINGS);
        CoreSettings settings = (CoreSettings) SystemOption.findObject(clazz, true);
        
        // change settings
        int def = settings.getAutoParsingDelay();
        settings.setAutoParsingDelay(2*def);
        assertEquals("Invalid setting AutoParsingDelay", settings.getAutoParsingDelay(), 2*def);
        
        /* FIXME - throws NoClassDefFoundError
        // reinstall module
        TestUtil.switchModule(TestUtil.CORE_PACKAGE, false);
        //try {Thread.currentThread().sleep(5000);} catch (Exception e) {}; //!!! hack
        TestUtil.switchAllXMLModules(true);
         
        // check restoreed setting
        assertEquals("Invalid setting AutoParsingDelay", settings.getAutoParsingDelay(), 2*def);
         */
        
        // set default setting
        settings.setAutoParsingDelay(def);
    }
    
    /**
     * Performs this testsuite.
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        TestRunner.run(CoreSettingsTest.class);
    }
}
