/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.settings;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ClassLoader;
import java.lang.reflect.Method;
import java.util.TreeMap;
import org.openide.options.ContextSystemOption;
import org.openide.options.SystemOption;
import org.openide.util.Lookup;
import org.openide.util.io.NbMarshalledObject;

/**
 * SystemOption (settings) test looking for changed options.
 * Create it, setIO then perform testSystemOption().
 *
 * @author  mryzl, Petr Kuzel
 * @version
 */
public class SystemOptionTest {
    
    private String result = "";
    
    /** Get a system option by name.
     * @param className     name of the class
     * @return              a system option
     */
    public String testSystemOption(String className) {
        result = "";
        refSystemOption(className);
        return result;
    }
    
    private void ref(String s) {
        result += s + "\n";
    }
    
    private void refSystemOption(String className) {
        // introduction
        ref("========================================");
        try {
            // get class
            ClassLoader loader = (ClassLoader) Lookup.getDefault().lookup(ClassLoader.class);
            Class clazz = loader.loadClass(className);
            ref("  className = " + clazz.getName());
            
            // get option
            SystemOption so = (SystemOption) SystemOption.findObject(clazz, true);
            
            // serializability
            NbMarshalledObject mo = new NbMarshalledObject(so);
            mo.get();
            ref("  serializable = true");
            
            // bean info
            ref("bean info:");
            BeanInfo bi = Introspector.getBeanInfo(clazz);
            ref("  class = " + bi.getClass().getName());
            
            // bean descriptor
            ref("bean descriptor:");
            BeanDescriptor bd = bi.getBeanDescriptor();
            ref("  name = " + bd.getName());
            ref("  displayName = " + bd.getDisplayName());
            ref("  shortDescription = " + bd.getShortDescription());
            ref("  hidden = " + bd.isHidden());
            ref("  customizer = " + getClassName(bd.getClass()));
            
            // properties
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            
            // sort properties
            TreeMap smap = new TreeMap();
            for(int i = 0; i < pds.length; i++) {
                smap.put(pds[i].getName(), pds[i]);
            }
            pds = (PropertyDescriptor[]) smap.values().toArray(pds);
            
            for(int i = 0; i < pds.length; i++) {
                ref("property:");
                ref("  name = " + pds[i].getName());
                ref("  type = " + getClassName(pds[i].getPropertyType()));
                ref("  getter = " + getMethodName(pds[i].getReadMethod()));
                ref("  setter = " + getMethodName(pds[i].getWriteMethod()));
                ref("  displayName = " + pds[i].getDisplayName());
                ref("  shortDescription = " + pds[i].getShortDescription());
                ref("  hidden = " + pds[i].isHidden());
                ref("  editor = " + getClassName(pds[i].getPropertyEditorClass()));
            }
            
            ref("additional bean infos:");
            BeanInfo[] bis = bi.getAdditionalBeanInfo();
            if (bis != null) {
                for(int i = 0; i < bis.length; i++) {
                    ref("  class = " + getClassName(bis[i].getClass()));
                }
            }
            
            ref("========================================");
            
            if (so instanceof ContextSystemOption) {
                ref("context:");
                SystemOption[] sos = ((ContextSystemOption) so).getOptions();
                for(int i = 0; i < sos.length; i++) {
                    refSystemOption(getClassName(sos[i].getClass()));
                }
            }
            
            
        } catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw, true));
            ref("----------------------------------------");
            ref(sw.toString());
        }
    }
    
    /** Get name of the class.
     * @param clazz     class
     * @return          name of the class or null
     */
    private String getClassName(Class clazz) {
        if (clazz != null) return clazz.getName();
        return null;
    }
    
    /** Get name of the method.
     * @param clazz     class
     * @return          name of the class or null
     */
    private String getMethodName(Method method) {
        if (method != null) return method.getName();
        return null;
    }
}
