/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * SchemaParserTest.java
 * NetBeans JUnit based test
 *
 * Created on July 24, 2002, 11:44 PM
 */

package org.netbeans.modules.xml.core.wizard;

import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import junit.framework.*;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.junit.*;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 *
 * @author Petr Kuzel <petr.kuzel@sun.com>
 */
public class SchemaParserTest extends NbTestCase {
    
    public SchemaParserTest(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite(SchemaParserTest.class);
        
        return suite;
    }
    
    /** Test of parse method, of class org.netbeans.modules.xml.core.wizard.SchemaParser. */
    public void testParse() {
        System.out.println("testParse");
        
        URL ns = getClass().getResource("data/schemaWithNS.xsd");
        SchemaParser parser = new SchemaParser();

        SchemaParser.SchemaInfo info = parser.parse(ns.toExternalForm());        
        assertTrue("root expected",info.roots.contains("root"));
        assertTrue("ns expected", "test:schemaWithNS".equals(info.namespace));
        assertTrue("unexpected root", info.roots.contains("seq1") == false);
    }
            
}
