/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css;

import java.io.IOException;
import java.util.*;
import java.text.*;

import org.openide.loaders.*;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.actions.*;
import org.openide.util.actions.SystemAction;
import org.openide.util.*;

import org.netbeans.modules.css.actions.*;

/** Data loader which recognizes CSS files.
 * This class is final only for performance reasons,
 * can be unfinaled if desired.
 *
 * @author Petr Kuzel
 */
public final class CSSLoader extends UniFileLoader {

    /** Serial Version UID */
    private static final long serialVersionUID = -6638807099960633333L;

    private static final String CSS_EXT = "css"; // NOI18N
    private static final String CSS_MIME = "text/css";  // NOI18N
    
    /** Creates new DTDLoader */
    public CSSLoader() {
        super("org.netbeans.modules.css.CSSObject");
    }

    /** Does initialization. Initializes display name,
     * extension list and the actions. */
    protected void initialize () {
        super.initialize();
        
        ExtensionList ext = getExtensions();
        ext.addExtension (CSS_EXT);
        ext.addMimeType(CSS_MIME);
        setExtensions(ext);
    }

    protected String actionsContext() {
        return "Loaders/text/css/Actions/";
    }
    
    /**
     * Lazy init name.
     */
    protected String defaultDisplayName () {
        return Util.THIS.getString ("PROP_CSSLoader_Name");        
    }
    
    /** Creates the right data object for given primary file.
     * It is guaranteed that the provided file is realy primary file
     * returned from the method findPrimaryFile.
     *
     * @param primaryFile the primary file
     * @return the data object for this file
     * @exception DataObjectExistsException if the primary file already has data object
     */
    protected MultiDataObject createMultiObject (FileObject primaryFile)
            throws DataObjectExistsException, java.io.IOException {
        return new CSSObject (primaryFile, this);
    }
    
    /** Creates the right primary entry for given primary file.
     *
     * @param primaryFile primary file recognized by this loader
     * @return primary entry for that file
     */
    protected MultiDataObject.Entry createPrimaryEntry (MultiDataObject obj, FileObject primaryFile) {
        return new CSSFileEntry (obj, primaryFile);
    }

    /** This entry defines the format for replacing the text during
     * instantiation the data object.
     * //!!! encoding hanling such as XML does
     */    
    public static class CSSFileEntry extends FileEntry.Format {

        /** Serial Version UID */
        private static final long serialVersionUID = 2833661760805697888L;
        
        /** Creates new MakefileFileEntry */
        CSSFileEntry (MultiDataObject obj, FileObject file) {
            super (obj, file);
        }

        /** Method to provide suitable format for substitution of lines.
         *
         * @param target the target folder of the installation
         * @param n the name the file will have
         * @param e the extension the file will have
         * @return format to use for formating lines
         */
        protected java.text.Format createFormat (FileObject target, String n, String e) {
            HashMap map = new HashMap();
            Date now = new Date();

            map.put ("NAME", n); // NOI18N
            map.put ("DATE", DateFormat.getDateInstance (DateFormat.LONG).format (now)); // NOI18N
            map.put ("TIME", DateFormat.getTimeInstance (DateFormat.SHORT).format (now)); // NOI18N
            map.put ("USER", System.getProperty ("user.name")); // NOI18N

            MapFormat format = new MapFormat (map);
            format.setLeftBrace ("__"); // NOI18N
            format.setRightBrace ("__"); // NOI18N
            format.setExactMatch (false);
            return format;
        }
    }

}
