/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.io.IOException;
import java.net.URL;
import java.util.*;

import org.openide.filesystems.*;
import org.openide.loaders.*;
import org.openide.text.*;
import org.openide.cookies.*;
import org.openide.util.*;
import org.openide.util.actions.*;
import org.openide.nodes.*;

import org.netbeans.modules.css.text.*;

import org.xml.sax.SAXException;

/**
 * CSSDataObject wraps CSS data layer functionality.
 *
 * This class is final only for performance reasons,
 * can be unfinaled if desired.
 *
 * @author Petr Kuzel
 */
public final class CSSObject extends MultiDataObject {
    private static final long serialVersionUID = -3041598815183192198L;
    public static final String MIME_TYPE = "text/css"; // NOI18N


    public CSSObject(final FileObject obj,final UniFileLoader loader) throws DataObjectExistsException {
        super (obj, loader);

        CookieSet set = getCookieSet();
        set.add (new CSSEditorSupport(getPrimaryEntry()));

        getPrimaryFile().addFileChangeListener (FileUtil.weakFileChangeListener(new FileListener (), getPrimaryFile()));
    }

    /** Provides node that should represent this data object. When a node for representation
     * in a parent is requested by a call to getNode (parent) it is the exact copy of this node
     * with only parent changed. This implementation creates instance
     * <CODE>DataNode</CODE>.
     * <P>
     * This method is called only once.
     *
     * @return the node representation for this data object
     * @see DataNode
     */
    protected Node createNodeDelegate () {
        return new CSSNode (this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx (CSSObject.class);
    }

    /////////////////////
    // class FileListener
    class FileListener extends FileChangeAdapter {

        /** Fired when a file is changed.
         * @param fe the event describing context where action has taken place
         */
        public void fileChanged (FileEvent fe) {

        }

    } // end of inner class FileListener

}
