/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css.actions;

import java.awt.datatransfer.StringSelection;
import java.net.*;
import java.io.*;

import org.openide.*;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.*;
import org.openide.util.actions.*;
import org.openide.filesystems.*;
import org.openide.cookies.*;

import org.w3c.css.sac.*;

import org.netbeans.modules.css.*;

/**
* Action that reparses stylesheet and reports any syntax errors.
*
* @author Petr Kuzel
*/
public class CheckStyleAction extends CookieAction implements ErrorHandler, DocumentHandler {

    /** Serial Version UID */
    private static final long serialVersionUID = -6638807099960633338L;
    
    private CSSObject csso;         //currently processed object
    private CSSDisplayer disp;      //and its displayer
    
    //check status
    private boolean failed;
    private int warnings;
    
    /** What triggers me?
    * @return MODE_EXACTLY_ONE.
    */
    public int mode() {
        return MODE_EXACTLY_ONE;
    }

    /** What triggers me?
    * @return {CSSObject.class}
    */
    public Class[] cookieClasses() {
        return new Class[] {CSSObject.class};
    }

    /** Action.
    */
    protected void performAction(final Node[] nodes) {
        if (nodes.length != 1) return;
        if (nodes[0] == null) return;
        
        failed = false;
        warnings = 0;

        disp = new CSSDisplayer();

        Parser parser = new org.w3c.flute.parser.Parser();
        parser.setErrorHandler(this);
        parser.setDocumentHandler(this);
        
        for (int i=0; i<nodes.length; i++) {
            csso = (CSSObject) nodes[i].getCookie(CSSObject.class);
            
            if (csso != null) {
                try {
                    //save it first
                    //!!! it could use document
                    SaveCookie cake = (SaveCookie) csso.getCookie(SaveCookie.class);
                    if (cake != null)
                        cake.save();
                    
                    String uri = csso.getPrimaryFile().getURL().toExternalForm();

                    parser.parseStyleSheet(uri);
                } catch (IOException ex) {
                    // ??? provide better feedback TopManager.getDefault().getErrorManager().notify(ex);
                    failed = true;
                } catch (CSSParseException ex) {
                    // ??? provide better feedback 
                    failed = true;
                }
            }
        }

        if ( ( failed == true ) ||
             ( warnings > 0 ) ) {
            disp.moveToFront();
        }
        StatusDisplayer.getDefault().setStatusText(Util.THIS.getString("TEXT_PART_CSS_checking") + getStatus() + "."); // NOI18N
    }

    
    private String getStatus() {
        return failed ? Util.THIS.getString("TEXT_PART_failed") : warnings>1 ? Util.THIS.getString("TEXT_PART_finished_with_warnings") : Util.THIS.getString("TEXT_PART_finished");
    }
    
    public String getName() {
        return Util.THIS.getString("NAME_check_CSS");
    }
    
    protected String iconResource () {
        return "org/netbeans/modules/css/resources/checkStyleAction.gif";       // NOI18N
    }
    
    /** Get help context for the action.
    */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(getClass());
    }

    // ~~~~~~~~~~~~~~~~~~~~~ PARSER LISTENER ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    public void warning(CSSParseException exception) throws CSSException {
        disp.display(csso, exception);
        warnings++;
    }
    
    public void error(CSSParseException exception) throws CSSException {
        disp.display(csso, exception);        
        failed = true;
    }
    
    public void fatalError(CSSParseException exception) throws CSSException {
        disp.display(csso, exception);        
        failed = true;
    }
    
    // ~~~~~~~~~~~~~~~~~ VOID ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~`
    
    public void startDocument(InputSource source) throws CSSException {
    }
    
    public void endDocument(InputSource source) throws CSSException {
    }
    
    public void comment(String text) throws CSSException {
    }
    
    public void ignorableAtRule(String atRule) throws CSSException {
    }
    
    public void namespaceDeclaration(String prefix,String uri) throws CSSException {
    }
    
    public void importStyle(String uri,SACMediaList media,String defaultNamespaceURI) throws CSSException {
    }
    
    public void startMedia(SACMediaList media) throws CSSException {
    }
    
    public void endMedia(SACMediaList media) throws CSSException {
    }

    public void startPage(String name,String pseudo_page) throws CSSException {
    }
    
    public void endPage(String name,String pseudo_page) throws CSSException {
    }
    
    public void startFontFace() throws CSSException {
    }
    
    public void endFontFace() throws CSSException {
    }
    
    public void startSelector(SelectorList selectors) throws CSSException {
    }
    
    public void endSelector(SelectorList selectors) throws CSSException {
    }
    
    public void property(String name,LexicalUnit value,boolean important) throws CSSException {
    }
}
