/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css.text.syntax;

import javax.swing.text.Document;

import org.openide.*;

import org.netbeans.editor.*;
import org.netbeans.modules.editor.*;
import org.netbeans.modules.editor.options.AllOptions;

import org.netbeans.modules.css.text.syntax.javacc.lib.*;
import org.netbeans.modules.css.text.syntax.javacc.*;

import org.netbeans.modules.css.CSSObject;

/**
 * Editor kit implementation for CSS content type.
 * It is used in run-time only if editor (Mila's) is installed.
 *
 * @author  Petr Kuzel
 * @version jj
 */
public class CSSEditorKit extends NbEditorKit {

private static final long serialVersionUID = -5758543042688196595L;

    /** Create new instance of syntax coloring parser */
    public Syntax createSyntax(Document doc) {
        return new JJEditorSyntax( 
            new CSSSyntaxTokenManager(null).new Bridge(),
            new CSSEditorSyntaxMapper(),
            CSSTokenContext.contextPath
        );
    }

    public Document createDefaultDocument() {
        return new NbEditorDocument (this.getClass());
    }

    public String getContentType() {
        return CSSObject.MIME_TYPE;
    }

}
