/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css.text.syntax;

import java.awt.Font;
import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;

import org.openide.actions.ToolsAction;
import org.openide.windows.TopComponent;

import org.netbeans.editor.*;
import org.netbeans.editor.ext.ExtSettingsNames;

import org.netbeans.modules.css.actions.*;
import org.netbeans.modules.css.text.syntax.CSSTokenContext;

/**
 * Settings.Initializer for CSSEditor
 *
 * @author  Petr Kuzel
 * @version 1.0
 */
public class CSSEditorSettings extends Settings.AbstractInitializer {

    /** Name assigned to initializer */
    public static final String NAME = "css-settings-initializer"; // NOI18N

    static final Font boldFont = SettingsDefaults.defaultFont.deriveFont(Font.BOLD);
    static final Font italicFont = SettingsDefaults.defaultFont.deriveFont(Font.ITALIC);

    /** Creates new CSSEditorSettings */
    public CSSEditorSettings() {
        super(NAME);
    }

    /** Update map filled with the settings from the previous initializer
     * @param kitClass kit class for which the settings are being updated.
     *  It is always non-null value.
     * @param settingsMap map with settings to update. It can be null if all
     *  the previous initializers didn't need to create any settings
     *  for the given kit class.
     * @return map containing the desired settings or null if no settings
     *  are defined for the given kit
     */
    public void updateSettingsMap(Class kitClass, Map settingsMap) {

        // editor breaks the contact, handle it somehow
        if (kitClass == null) return;
        
        if (kitClass == BaseKit.class) {

            new CSSTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
            // coloring has to be present in base kit

        }

        // #21053
        if ("org.netbeans.modules.css.text.syntax.CSSEditorKit".equals(kitClass.getName())) {
            
            // popup menu
            
            List cssActionNames = new ArrayList
                (Arrays.asList (new String[] {
                    CopyStyleAction.XML.class.getName(),
                    CopyStyleAction.HTML.class.getName(),
                    CheckStyleAction.class.getName(),
                    null,
// <comment> Wait for indent engine.
//                     BaseKit.formatAction,
//                     null,
// </comment>
                    TopComponent.class.getName(),
                    null,
                    BaseKit.cutAction,
                    BaseKit.copyAction,
                    BaseKit.pasteAction,
                    null,
                    BaseKit.removeSelectionAction,
                    null,
                    ToolsAction.class.getName(),
                }));
            
            settingsMap.put (ExtSettingsNames.POPUP_MENU_ACTION_NAME_LIST, cssActionNames);

            // abbrevirations
            settingsMap.put (SettingsNames.ABBREV_MAP, getCSSAbbrevMap());

            SettingsUtil.updateListSetting (settingsMap, SettingsNames.TOKEN_CONTEXT_LIST,
                    new TokenContext[] { CSSTokenContext.context });

        }

    }

    /** @return Map of common CSS abbrevirations.
    */
    private Map getCSSAbbrevMap() {
        Map map = new TreeMap();

        map.put ("bg", "background: "); // NOI18N
        map.put ("di", "display: "); // NOI18N
        map.put ("fs", "font-size: "); // NOI18N

        return map;
    }

    /** CSS colorings for standalone editor */
    static class CSSTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {

        public CSSTokenColoringInitializer() {
            super(CSSTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenIDOrCategory, boolean printingSet) {
            return new Coloring (null, Color.black, null);
        }

    }

}
