/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css.text.syntax;

import org.netbeans.editor.*;
import org.netbeans.modules.css.text.syntax.javacc.lib.*;
import org.netbeans.modules.css.text.syntax.javacc.CSSSyntaxConstants;

/**
 * Factory mappring jjID => TokenID.
 *
 * @author  Petr Kuzel
 * @version 1.0
 */
public class CSSEditorSyntaxMapper implements JJMapperInterface, JJConstants, CSSSyntaxConstants {
    
    
    /** Create token for particular ID.  */
    public JJTokenID createToken(int id) {
        
        switch(id) {
            
            case JJ_EOL:
                return CSSTokenContext.EOL;
                
            case JJ_EOF:
                throw new Error("guessToken() must be called for such case."); // NOI18N
                
            case JJ_ERR:
            case ERR_IN_COMMENT:

                return CSSTokenContext.ERROR;
                
                
            case MEDIA_DECL:
            case ATKW:
                
                return CSSTokenContext.ATKW;
                
            case COMMENT_IN_RULESET:
            case CCOMMENT_IN_RULESET:
            case COMMENT_START:
            case TEXT_IN_COMMENT:
            case COMMENT_END:
            case CCOMMENT_START:
            case CCOMMENT_END:
            case TEXT_IN_CCOMMENT:
                
                return CSSTokenContext.COMMENT;
                
            case SELECTOR:
                
                return CSSTokenContext.SELECTOR;
                
            case PROP:
                return CSSTokenContext.PROPERTY;
                
            default:
                return CSSTokenContext.PLAIN;
        }
        
    }
    /** @return token guessed for particular state.  */
    public final JJTokenID guessToken(String token,int state,boolean lastBuffer) {
        
        switch (state) {                
             default:
                 return cannotGuess(lastBuffer);
        }
    }
    
    private JJTokenID cannotGuess(boolean lastBuffer) {
        return cannotGuess(lastBuffer, CSSTokenContext.PLAIN);
    }
    
    private JJTokenID cannotGuess(boolean lastBuffer, JJTokenID supposed) {
        if (lastBuffer) {
            return supposed;
        } else {
            //ask for next buffer
            return null;
        }        
    }
    
    /** Called if  createToken(int id) return isError() token.
    * @return supposed token for particular id and state. 
     */
    public JJTokenID supposedToken(String token,int state,int id) {
        
        switch (state) {            
            case IN_COMMENT:
                return CSSTokenContext.COMMENT;
                
            default:
                return null;
        }
    }
    
}
