/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring;

import java.util.Set;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.openide.ErrorManager;

/**
 *
 * @author Nam Nguyen
 */
public class DeleteRequest extends RefactorRequest {
    private boolean done = false;
    private NamedReferenceable target;
    // need to save target model as target.getModel will return null after delete happen
    private Model model;  

    /** Creates a new instance of RenameRequest */
    public DeleteRequest(NamedReferenceable target) {
        this(target, null);
    }
    
    public DeleteRequest(NamedReferenceable target, Set<Component> scope) {
        super(scope);
        if (target == null || target.getModel() == null) {
            throw new IllegalArgumentException("Cannot delete null or deleted component");
        }
        this.target = target;
        model = target.getModel();
    }

    public NamedReferenceable getTarget() {
        return target;
    }
    
    @Override
    public Model getTargetModel() {
        return model;
    }
    
    public String getTargetName() {
        return target.getName();
    }
    
    public Class<DeleteRequest> getType() {
        return DeleteRequest.class;
    }
    
    public boolean confirmChangePerformed() {
        String name = getTarget() instanceof Named ? ((Named)getTarget()).getName() : "component"; //NOI18N
        if (! isDone()) {
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, 
                    "Failed to delete target " + name); //NOI18N
        }
        return isDone();
    }
    
    /**
     * Target deleted.
     */
    public boolean isDone() {
        return done;
    }
    public void setDone(boolean v) {
        done = v;
    }
}
