/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring;

import java.util.Set;
import org.netbeans.modules.xml.refactoring.impl.RefactoringUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;

/**
 *
 * @author Nam Nguyen
 */
public class FileRenameRequest extends RefactorRequest {
    private String oldFileName;
    private String newFileName;
    private Model target;

    /** Creates a new instance of FileRenameRequest */
    public FileRenameRequest(Model target) {
        this(target, (Set<Component>)null);
    }
    
    public FileRenameRequest(Model target, Set<Component> scope) {
        super(scope);
        if (! (target instanceof Model)) {
            throw new IllegalArgumentException("Expect refactor target is a Model instance");
        }
        this.target = target;
        oldFileName = getTargetName();
    }
    
    public FileRenameRequest(Model target, String newFileName) {
        this(target, (Set<Component>)null);
        this.newFileName = newFileName;
    }
    
    public Class<FileRenameRequest> getType() {
        return FileRenameRequest.class;
    }
    
    public boolean confirmChangePerformed() {
        return getFileObject().getName().equals(newFileName);
    }
    
    public Model getTarget() {
        return target;
    }

    public String getOldFileName() {
        return oldFileName;
    }
    
    public String getNewFileName() {
        return newFileName;
    }

    public void setNewFileName(String v) {
        newFileName = v;
    }
    
    public String getTargetName() {
        return this.getFileObject().getName();
    }
    
    public String calculateNewLocationString(String currentLocationString) {
        StringBuilder sb = new StringBuilder();
        int i = currentLocationString.lastIndexOf('/');
        if (i > -1) {
            sb.append(currentLocationString.substring(0, i+1));
        }
        sb.append(getNewFileName());
        sb.append("."); //NOI18N
        sb.append(getFileObject().getExt());
        return sb.toString();
    }

    public void precheckChange() {
        super.precheckChange();
        ErrorItem error = RefactoringUtil.precheck(this);
        if (error != null) {
            addError(error);
        }
    }

}
