/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring;

import java.util.Set;
import org.netbeans.modules.xml.refactoring.impl.RefactoringUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.openide.ErrorManager;

/**
 *
 * @author Nam Nguyen
 */
public class RenameRequest extends RefactorRequest {
    private Nameable target;
    private String oldName;
    private String newName;
    private Nameable renamed;

    /** Creates a new instance of RenameRequest */
    public RenameRequest(Nameable target, String newName) {
        this(target, newName, null);
    }
    
    public RenameRequest(Nameable target, String newName, Set<Component> scope) {
        super(scope);
        assert target instanceof NamedReferenceable;
        this.target = target;
        this.oldName = target.getName();
        this.newName = newName;
    }
    
    public Class<RenameRequest> getType() {
        return RenameRequest.class;
    }
    
    public boolean confirmChangePerformed() {
        String name = getTarget().getName();
        if (getRenamedTarget() == null) {
            ErrorManager.getDefault().log(ErrorManager.INFORMATIONAL, 
                    "Failed to rename target " + name); //NOI18N
        }
        return  (getRenamedTarget() != null);
    }
    
    public NamedReferenceable getTarget() {
        return (NamedReferenceable) target;
    }

    public Nameable getNameableTarget() {
        return target;
    }
    
    public String getTargetName() {
        return getOldName();
    }
    
    public Nameable getRenamedTarget() {
        return renamed;
    }
    
    public void setRenamedTarget(Nameable renamed) {
        this.renamed = renamed;
    }

    public String getNewName() {
        return newName;
    }
    
    public void setNewName(String v) {
        newName = v;
    }
    
    public String getOldName() {
        return oldName;
    }

    public void precheckChange() {
        super.precheckChange();
        ErrorItem error = RefactoringUtil.precheck(this);
        if (error != null) {
            addError(error);
        }
    }
}
