/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.refactoring.impl.RefactoringUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Reference;


public class Usage {
    private Component component;
    private Type type;
    private UsageGroup container;
    private boolean includedInRefactoring;
    private String refactoringDescription;
    
    public Usage(Component component, UsageGroup container) {
        this(component, Type.REFERENCE, container);
    }
    
    public Usage(Component component, Type type, UsageGroup container) {
        this.component = component;
        this.type = type;
        this.container = container;
        includedInRefactoring = true;
    }
    
    public enum Type {
        REFERENCE, GENERALIZATION;
        public String toString() {
            return RefactoringUtil.getDescription(this);
        }
    }

    /**
     * Returns component having the usage.
     */
    public Component getComponent() {
        return component;
    }
    
    /**
     * Returns type of the usage.
     */
    public Type getType() {
        return type;
    }
    
    public void setType(Type type) {
        this.type = type;
    }
    
    /**
     * Return the containing group of this usage.
     */
    public UsageGroup getContainer() {
        return container;
    }
    
    /**
     * Returns path from root to the usage host component.
     */
    public List<Component> getPathFromRoot() {
        return getContainer().getEngine().getUIHelper().getRelevantPathFromRoot(this.getComponent());
    }
    
    /**
     * Whether this usage item should be included in refactoring.
     */
    public boolean isIncludedInRefactoring() { 
        return includedInRefactoring; 
    }
    public void setIncludedInRefactoring(boolean included) {
        includedInRefactoring = included;
    }
    
    /**
     * Returns short description of the change would be done on this usage item
     * if the refactoring is applied.  Return null if this usage item has not been
     * associated with any refactoring request with a call to 
     * RefactoringManager.precheck().
     */
    public String getRefactoringDescription() {
        return refactoringDescription;
    }
    public void setRefactoringDescription(String desc) {
        this.refactoringDescription = desc;
    }
}