/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring.actions;

import org.netbeans.modules.xml.refactoring.FileRenameRequest;
import org.netbeans.modules.xml.refactoring.RefactoringManager;
import org.netbeans.modules.xml.refactoring.impl.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.FileRenameRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.j.ui.RefactoringPanel;
import org.netbeans.modules.xml.refactoring.ui.util.AnalysisUtilities;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.TopComponent;

/**
 *
 * @author Nam Nguyen
 */
public class FileRenameAction extends CookieAction {
    public static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    
    /** Creates a new instance of FileRenameAction */
    public FileRenameAction() {
        super();
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        Referenceable ref = AnalysisUtilities.getReferenceable(activatedNodes);
        return ref instanceof Model && RefactoringUtil.isWritable((Model)ref) && 
               RefactoringManager.getInstance().canChange(FileRenameRequest.class, ref);
    }
    
    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length != 1) return;

        Referenceable ref = AnalysisUtilities.getReferenceable(activatedNodes);
        if (ref instanceof Model) {
            Model model = (Model) ref;
            WhereUsedView wuv = new WhereUsedView(model);
            FileRenameRefactoringUI ui = new FileRenameRefactoringUI(wuv, model);
            TopComponent activetc = TopComponent.getRegistry().getActivated();
            if (activetc instanceof CloneableEditorSupport.Pane) {
                new RefactoringPanel(ui, activetc);
            } else {
                new RefactoringPanel(ui);
            }
        }
    }

    protected int mode() {
        return CookieAction.MODE_EXACTLY_ONE;
    }

    public String getName() {
        return NbBundle.getMessage(FileRenameAction.class, "LBL_FileRename");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Class[] cookieClasses() {
        return EMPTY_CLASS_ARRAY;
    }

    protected boolean asynchronous() {
        return false;
    }
}
