/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.refactoring.actions;

import org.netbeans.modules.xml.refactoring.RefactorRequest;
import org.netbeans.modules.xml.refactoring.impl.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.ui.ReferenceableProvider;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.DeleteRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.j.ui.RefactoringPanel;
import org.netbeans.modules.xml.refactoring.ui.util.AnalysisUtilities;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.TopComponent;

/**
 * Remove the selected component(s) from the schema model. If the components
 * are referenced elsewhere, the user will be asked for confirmation before
 * removing them.
 *
 * @author Nathan Fiedler
 * @author Jerri Lockhart
 */
public class SafelyDeleteAction extends CookieAction {
    /** silence compiler warnings */
    private static final long serialVersionUID = 1L;
    
    private static final Class[] COOKIE_ARRAY =
            new Class[] {ReferenceableProvider.class };
    
    /**
     * Creates a new instance of RemoveAction.
     */
    public SafelyDeleteAction() {
        putValue("noIconInMenu", Boolean.TRUE); // NOI18N
    }
    
    protected boolean asynchronous() {
        return false;
    }
    
    protected boolean enable(Node[] nodes) {
        if (super.enable(nodes)) {
            Referenceable ref = AnalysisUtilities.getReferenceable(nodes);
            return ref instanceof NamedReferenceable && 
                    RefactoringUtil.isWritable(RefactorRequest.getModel(ref)) && 
                    nodes[0].canDestroy();
        }
        return false;
    }
    
    public HelpCtx getHelpCtx() {
        // Leverage the help of the core action.
        return HelpCtx.DEFAULT_HELP;
    }
    
    public String getName() {
        return NbBundle.getMessage(SafelyDeleteAction.class, "LBL_Remove");
    }
    
    /**
     * Perform the action based on the currently activated nodes.
     * Note that if the source of the event triggering this action was itself
     * a node, that node will be the sole argument to this method, rather
     * than the activated nodes.
     *
     *
     * @param activatedNodes current activated nodes, may be empty but not <code>null</code>
     */
    protected void performAction(Node[] nodes) {
        
        assert nodes.length==1:
            "Length of nodes array should be 1";
        Referenceable ref = AnalysisUtilities.getReferenceable(nodes);
        if (ref instanceof Component && ((Component)ref).getParent() == null) {
            return;
        }
        assert ref instanceof NamedReferenceable:"The NamedReferenceable for this node should not be null";
        WhereUsedView wuv = new WhereUsedView(ref);
        DeleteRefactoringUI ui = new DeleteRefactoringUI(wuv, NamedReferenceable.class.cast(ref));
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        if (activetc instanceof CloneableEditorSupport.Pane) {
            new RefactoringPanel(ui, activetc);
        } else {
            new RefactoringPanel(ui);
        }
    }
    
  
    
    protected int mode() {
        return CookieAction.MODE_EXACTLY_ONE;
    }
    
    
    
    protected Class[] cookieClasses() {
        return COOKIE_ARRAY;
    }
}
