/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.refactoring.ui.j.spi.ui;

import java.text.MessageFormat;
import org.netbeans.modules.xml.nbprefuse.View;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.RefactorRequest;
import org.netbeans.modules.xml.refactoring.RenameRequest;
import org.netbeans.modules.xml.refactoring.impl.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.ui.j.api.AbstractRefactoring;
import org.netbeans.modules.xml.refactoring.ui.j.api.Problem;
import org.netbeans.modules.xml.refactoring.ui.j.api.WhereUsedQuery;
import org.netbeans.modules.xml.refactoring.ui.j.ui.RefactoringPanel;
import org.netbeans.modules.xml.refactoring.ui.j.ui.RenamePanel;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Jeri Lockhart
 */
public class RenameRefactoringUI implements RefactoringUI{
    
    private WhereUsedQuery query;
    private WhereUsedView view;
    private String newName = "", oldName = "";  //NOI18N
    private RenamePanel panel;
    private RenameRequest renameRequest;
    private Nameable target;
	private boolean editable;
    
    /** Creates a new instance of WhereUsedQueryUI */
    public RenameRefactoringUI(WhereUsedView view, RenameRequest request) {
        this(view, (Nameable) request.getTarget(), request.getNewName(), true);
        renameRequest = request;
    }

    public RenameRefactoringUI(WhereUsedView view, Nameable ref) {
        this(view,ref,ref.getName(),true);
    }
    
    /** 
	 * Creates a new instance of RenameRefactoringUI.
	 * In addition to whereusedview and namedreferenceable,
	 * new name and editable flag is also provided.
	 * It is called from scn.setname and name property.
	 */
    public RenameRefactoringUI(WhereUsedView view,
            Nameable ref, String name, boolean editable) {
        this.view = view;
        this.target = ref;
        oldName = name;
		this.editable = editable;
        assert ref instanceof NamedReferenceable;
        query = new WhereUsedQuery((NamedReferenceable) ref);
    }

    ////////////////////////////////////////////////////////////////////////////
    /**  Start Implementation of RefactoringUI
     */
    ////////////////////////////////////////////////////////////////////////////
    /**
     * Returns refactoring-specific panel containing input fields for 
     * refactoring parameters. This method is called by ParametersPanel
     * which is responsible for displaying refactoring parameters dialog.
     * Name of the panel returned from this method will be used as the dialog
     * name. This panel can use setPreviewEnabled method of the passed
     * ParametersPanel to enable/disable Preview button of the refactoring
     * parameters dialog.
     * 
     * @param parent ParametersPanel that the returned panel will be displayed in.
     * @return Refactoring-specific parameters panel.
     */
    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
         if (panel == null) {
            String name = oldName;
            panel = new RenamePanel(oldName, 
                    parent, NbBundle.getMessage(RenamePanel.class, "LBL_Rename"), 
                    editable, 
                    false);
        }
        return panel;
    }

    /**
     * Implementation of this method should set the refactoring parameters entered
     * by user into the refactoring-specific parameters panel (returned from getPanel
     * method) into the underlying refactoring object.
     * 
     * @return Chain of problems returned from the underlying refactoring object
     * when trying to set its parameters.
     */
    public Problem setParameters() {
        return null;
    }

    /**
     * Indicates whether this class represents a real refactoring that changes
     * code or whether it is just a query (e.g. all usages for a class).
     * 
     * @return <code>true</code> if the class represents only a query,
     * <code>false</code> if the class represents a real refactoring.
     */
    public boolean isQuery() {
        return false;
    }

    public boolean hasParameters() {
        return true;
    }

    /**
     * Returns underlying refactoring object.
     * 
     * @return Underlying refactoring object.
     */
    public AbstractRefactoring getRefactoring() {
        return query;
    }

    /**
     * Returns name of the refactoring.
     * 
     * @return Refactoring name.
     */
   
    public String getName() {
        return new MessageFormat(NbBundle.getMessage(RefactoringPanel.class, "LBL_Rename")).format (
                    new Object[] {oldName}
                );
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RenameRefactoringUI.class);
    }

    /**
     * Returns description of the refactoring.
     * 
     * @return Refactoring description.
     */
    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RefactoringPanel.class, "DSC_Rename")).format (
                    new Object[] {oldName, newName } 
                );
        
    }

    public Problem checkParameters() {
        Problem problem = null;
        ErrorItem error = RefactoringUtil.precheck(this.getRefactorRequest());
        if (error != null) {
            Problem p = new Problem(true, error.getMessage());
            if (problem == null) {
                problem = p;
            } else {
                problem.setNext(p);
            }
        }
        return problem;
    }
    
    public View getView() {
       return view;    
    }
    
    public void setView(View view){
        
        this.view = WhereUsedView.class.cast(view);
    }
    
    
    /**
     * 
     * 
     * @returns RefactorRequest
     */
    public RenameRequest getRefactorRequest() {
        if (renameRequest == null) {
            renameRequest = new RenameRequest(target, "newName"); //NOI18N
        }
        if (getNewName() != null && getNewName().length() > 0) {
            renameRequest.setNewName(getNewName());
        }
        return renameRequest;
    }
    
    ////////////////////////////////////////////////////////////////////////////
    /**  End Implementation of RefactoringUI
     */
    ////////////////////////////////////////////////////////////////////////////

    public String getNewName(){
        if (panel != null){
            newName = panel.getNameValue();
        }
        
        return newName == null?"":newName;  //NOI18N
    }
    
    
    
    /**
     * @param target the Component to be renamed, must be a Nameable
     *
     */
    public void setNameableTarget(Nameable target){
        this.target = target;
    }
    
    public Nameable getNameableTarget(){
        return this.target;
    }
    
    public Referenceable getTarget() {
        assert target instanceof Referenceable;
        return (Referenceable) target;
    }
}
