/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.refactoring.ui.j.ui;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.xml.refactoring.ui.j.api.RefactoringElement;
import org.openide.nodes.Node;

/**
 * This listener controls click and double click on the CheckNodes. In addition
 * to it provides support for keyboard node checking/unchecking and opening
 * document.
 *
 * todo (#pf): Improve behaviour and comments.
 *
 * @author  Pavel Flaska
 */
class CheckNodeListener implements MouseListener, KeyListener {
    private final boolean isQuery;
    private PropertyChangeSupport propertyChangeSupport;
    
    public CheckNodeListener(boolean isQuery) {
        this.isQuery = isQuery;
        propertyChangeSupport = 
            new PropertyChangeSupport(this);
        
    }

    public void mouseClicked(MouseEvent e) {
        // todo (#pf): we need to solve problem between click and double
        // click - click should be possible only on the check box area
        // and double click should be bordered by title text.
        // we need a test how to detect where the mouse pointer is
        JTree tree = (JTree) e.getSource();
        Point p = e.getPoint();
        int x = e.getX();
        int y = e.getY();
        int row = tree.getRowForLocation(x, y);
        TreePath path = tree.getPathForRow(row);

        // if path exists and mouse is clicked exactly once
        if (path != null) {
            CheckNode node = (CheckNode) path.getLastPathComponent();
            if (isQuery) {
                if (e.getClickCount() == 2) {
                    if (node.getChildCount() == 0){
                        doPreferredAction(node);
                    } else {
                        if (tree.isCollapsed(row))
                            tree.expandRow(row);
                        else
                            tree.collapseRow(row);
                    }
                }
            } else {
                Rectangle chRect = CheckRenderer.getCheckBoxRectangle();
                Rectangle rowRect = tree.getPathBounds(path);
                chRect.setLocation(chRect.x + rowRect.x, chRect.y + rowRect.y);
                if (e.getClickCount() == 1 && chRect.contains(p)) {
                    boolean isSelected = !(node.isSelected());
                    node.setSelected(isSelected);
                    if (node.getSelectionMode() == CheckNode.DIG_IN_SELECTION) {
                        if (isSelected)
                            tree.expandPath(path);
                        else
                            tree.collapsePath(path);
                    }
                    ((DefaultTreeModel) tree.getModel()).nodeChanged(node);
                    if (row == 0) {
                        tree.revalidate();
                        tree.repaint();
                    }
                }
                // double click, open the document
                else if (e.getClickCount() == 2 && chRect.contains(p) == false) {
                    if (node.getChildCount() == 0){
                        doPreferredAction(node);
                    }
                    else {
                        if (tree.isCollapsed(row))
                            tree.expandRow(row);
                        else
                            tree.collapseRow(row);
                    }
                }
            }
        }
    }

    private void doPreferredAction(CheckNode node) {
	Node originalNode = node.getOrigNode();
	// originalNode could be null if the node was added as part of the 
	// refactoring infrastructure such as the find usage node
	if (originalNode != null) {
	    Action preferredAction = originalNode.getPreferredAction();
	    if (preferredAction != null) {
		String command = (String)
		preferredAction.getValue(Action.ACTION_COMMAND_KEY);
		ActionEvent ae = new ActionEvent(originalNode, 0, command);
		preferredAction.actionPerformed(ae);
	    }
	}
    }
    
    public void keyTyped(KeyEvent e) {
    }
    
    public void keyReleased(KeyEvent e) {
        // Enter key was pressed, find the reference in document
        if (e.getKeyCode() == KeyEvent.VK_ENTER) {
            JTree tree = (JTree) e.getSource();
            TreePath path = tree.getSelectionPath();
            if (path != null) {
                CheckNode node = (CheckNode) path.getLastPathComponent();
                findInSource(node);
            }
        }
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
    }
    
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == ' ') {
            JTree tree = (JTree) e.getSource();
            TreePath path = tree.getSelectionPath();
            if (path != null) {
                CheckNode node = (CheckNode) path.getLastPathComponent();
                node.setSelected(!node.isSelected());
                e.consume();
            }
        }
    }
    
    static void findInSource(CheckNode node) {
        Object o = node.getUserObject();
        if (o instanceof RefactoringElement) {
            ((RefactoringElement) o).openInEditor();
        }
    }
    
//    public void openSchemaView(CheckNode node){
//        Object o = node.getUserObject();
//        if (o instanceof Usage){
//            Usage usage = Usage.class.cast(o);
//            Component component = usage.getComponent();
//            if (component instanceof SchemaComponent){
//                SchemaComponent sc = SchemaComponent.class.cast(component);
//                AnalysisUtilities.openSchemaView(sc);
//            }
//        }
//    }

    
    public void addFindInSchemaViewListener(PropertyChangeListener l){
        propertyChangeSupport.addPropertyChangeListener(l);
    }
    
    public void removeFindInSchemaViewListener(PropertyChangeListener l){
        propertyChangeSupport.removePropertyChangeListener(l);
    }

} // end CheckNodeListener
