/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring.ui.j.ui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.netbeans.modules.xml.refactoring.DeleteRequest;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.RefactoringUI;
import org.openide.util.Utilities;

/**
 *
 * @author  Jan Becicka
 */
public class ErrorPanel extends javax.swing.JPanel {


    private static final long serialVersionUID = 1L;
    private static ImageIcon fatalImage = null, nonFatalImage = null;
    private boolean canContinueWithWarnings = true;
    
    private transient RefactoringUI ui;
    /** Creates new form ErrorPanel */
    public ErrorPanel(RefactoringUI ui, boolean canContinueWithWarnings) {
        this.ui = ui;
        this.canContinueWithWarnings = canContinueWithWarnings;
        initComponents();
        headLine.setText(canContinueWithWarnings?org.openide.util.NbBundle.getBundle(ErrorPanel.class).getString("LBL_ErrorPanelDescription"):org.openide.util.NbBundle.getBundle(ErrorPanel.class).getString("LBL_ErrorPanelDescription_Cannot_Continue_with_Warnings"));
        setPreferredSize(new Dimension(510, 200));
    }
    
    public ErrorPanel(List<ErrorItem> errorItems, RefactoringUI ui, boolean canContinueWithWarnings) {
        this(ui,canContinueWithWarnings);
        setProblems(errorItems);
    }
    
    public void setProblems(List<ErrorItem> errorItems) {
        errors.removeAll();
        int i = 0;
//        ProblemComponent.initButtonSize(problem);
        for (ErrorItem error:errorItems){
            GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i++;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
            gridBagConstraints.weightx = 1.0;
            
            ProblemComponent c = new ProblemComponent(error, ui);
            errors.add(c, gridBagConstraints);
            
            
            if (i%2 == 0) 
                c.setLightBackground();
            else 
                c.setDarkBackground();
            
            if (ui.getRefactorRequest() instanceof DeleteRequest) {
                //TODO straighten out usability issue of Safe Delete whether to allow 
                // cascade delete where possible
                break; // for now just a hack to show only first one assuming all entailed cascade delete not supported.
            }
        }

        GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = i;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        
        JPanel jp = new JPanel();
        jp.setBackground(Color.WHITE);
        errors.add(jp, gridBagConstraints);
    }
    
    static ImageIcon getFatalErrorIcon() {
        if (fatalImage == null) {
            fatalImage = new ImageIcon(Utilities.loadImage(
                    "org/netbeans/modules/refactoring/resources/error.png")); // NOI18N
        }
        return fatalImage;
    }
    
    static ImageIcon getNonfatalErrorIcon() {
        if (nonFatalImage == null) {
            nonFatalImage = new ImageIcon(Utilities.loadImage(
                    "org/netbeans/modules/refactoring/resources/warning.png")); //NOI18N
        }
        return nonFatalImage;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        listPanel = new javax.swing.JPanel();
        errorLabel = new javax.swing.JLabel();
        listScrollPane = new javax.swing.JScrollPane();
        errors = new javax.swing.JPanel();
        explanationPanel = new javax.swing.JPanel();
        fatalError = new javax.swing.JLabel();
        nonFatalError = new javax.swing.JLabel();
        headLine = new javax.swing.JTextArea();

        setLayout(new java.awt.BorderLayout());

        listPanel.setLayout(new java.awt.BorderLayout());

        org.openide.awt.Mnemonics.setLocalizedText(errorLabel, org.openide.util.NbBundle.getMessage(ErrorPanel.class, "LBL_ErrorsList"));
        listPanel.add(errorLabel, java.awt.BorderLayout.NORTH);

        listScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        errors.setLayout(new java.awt.GridBagLayout());

        listScrollPane.setViewportView(errors);

        listPanel.add(listScrollPane, java.awt.BorderLayout.CENTER);

        add(listPanel, java.awt.BorderLayout.CENTER);

        explanationPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        fatalError.setIcon(getFatalErrorIcon());
        org.openide.awt.Mnemonics.setLocalizedText(fatalError, org.openide.util.NbBundle.getMessage(ErrorPanel.class, "LBL_FatalError"));
        fatalError.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 20));
        explanationPanel.add(fatalError);

        nonFatalError.setIcon(getNonfatalErrorIcon());
        org.openide.awt.Mnemonics.setLocalizedText(nonFatalError, org.openide.util.NbBundle.getMessage(ErrorPanel.class, "LBL_NonFatalError"));
        explanationPanel.add(nonFatalError);

        add(explanationPanel, java.awt.BorderLayout.SOUTH);

        headLine.setBackground(javax.swing.UIManager.getDefaults().getColor("Panel.background"));
        headLine.setEditable(false);
        headLine.setFont(errorLabel.getFont());
        headLine.setLineWrap(true);
        headLine.setText(canContinueWithWarnings?org.openide.util.NbBundle.getBundle(ErrorPanel.class).getString("LBL_ErrorPanelDescription"):org.openide.util.NbBundle.getBundle(ErrorPanel.class).getString("LBL_ErrorPanelDescription_Cannot_Continue_with_Warnings"));
        headLine.setWrapStyleWord(true);
        headLine.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 10, 1));
        add(headLine, java.awt.BorderLayout.NORTH);
        headLine.getAccessibleContext().setAccessibleName(null);
        headLine.getAccessibleContext().setAccessibleDescription(null);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel errorLabel;
    private javax.swing.JPanel errors;
    private javax.swing.JPanel explanationPanel;
    private javax.swing.JLabel fatalError;
    private javax.swing.JTextArea headLine;
    private javax.swing.JPanel listPanel;
    private javax.swing.JScrollPane listScrollPane;
    private javax.swing.JLabel nonFatalError;
    // End of variables declaration//GEN-END:variables
    
}
