package org.netbeans.test.xml.schema.core;

import java.awt.Point;
import java.util.zip.CRC32;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.EditorOperator;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NewFileWizardOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.actions.PropertiesAction;
import org.netbeans.jellytools.actions.SaveAllAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.nodes.ProjectRootNode;
import org.netbeans.jellytools.properties.Property;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JListOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JRadioButtonOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.test.xml.schema.core.lib.SchemaMultiView;
import org.netbeans.test.xml.schema.core.lib.util.*;

/**
 *
 * @author kozlov@netbeans.org
 */

public class CreatePOSchemaTestCase extends JellyTestCase {
    
    static final String [] m_aTestMethods = {
        "createPOSchema"
    };
    
    static final String SCHEMA_NAME = "newXmlSchema";
    static final String SCHEMA_EXTENSION = ".xsd";
    
    
    private PropertySheetOperator pso = null;
    
    public CreatePOSchemaTestCase(String arg0) {
        super(arg0);
    }
    
    public static junit.framework.TestSuite suite() {
        junit.framework.TestSuite testSuite = new junit.framework.TestSuite("CreatePOSchema");
        
        for (String strMethodName : m_aTestMethods) {
            testSuite.addTest(new CreatePOSchemaTestCase(strMethodName));
        }
        
        return testSuite;
    }
    
    public void createPOSchema(){
        new PropertiesAction().performMenu();
        pso = new PropertySheetOperator();

        createSchema();
        openSchema();
        
        SchemaMultiView opMultiView = new SchemaMultiView(SCHEMA_NAME);
        opMultiView.switchToSchema();
        opMultiView.switchToSchemaColumns();
        JListOperator opList = opMultiView.getColumnListOperator(0);
        
        Operator.setDefaultStringComparator(new Operator.DefaultStringComparator(false, true));
        
        addAnnotation(opList, SCHEMA_NAME);
        JListOperator opList1 = opMultiView.getColumnListOperator(1);
        opList1.selectItem("annotation");
        
        addDocumentation(opList1);
        JListOperator opList2 = opMultiView.getColumnListOperator(2);
        opList2.selectItem("documentation");
        changeProperty("Language", "en");
        changeProperty("Text", "Purchase order schema for Example.com. Copyright 2000 Example.com. All rights reserved.");
        
        addSimpleType(opList, "SKU");
        opList1 = opMultiView.getColumnListOperator(1);
        opList1.selectItem("SKU");
        changeProperty("Pattern", "\\d{3}-[A-Z]{2}");
        
        
        addElement(opList, "comment", "Use Existing Type", "Built-in Types|string", "no");
        
        addComplexType(opList, "Items", 0, 0);
        opList1 = opMultiView.getColumnListOperator(1);
        opList1.selectItem("Items");
        
        addElement(opList1, "item", "Inline Complex Type", "no", "Items");
        JListOperator opList3 = opMultiView.getColumnListOperator(3);
        opList3.selectItem("item");
        changeProperty("Min Occurs", "0");
        changeProperty("Max Occurs", "unbounded");
        
        addElement(opList3, "productName","Use Existing Type", "Built-in Types|string", "item");
        
        addElement(opList3, "quantity", "Inline Simple Type", "no", "item");
        JListOperator opList7 = opMultiView.getColumnListOperator(7);
        customizeSimpleType(opList7, "Built-in Types|positiveInteger");
        changeProperty("Max Exclusive", "100");
        
        addElement(opList3, "USPrice","Use Existing Type", "Built-in Types|decimal", "item");
        
        addElementRef(opList3, "Elements|comment", "item");
        changeProperty("Min Occurs", "0");
        
        addElement(opList3, "shipDate","Use Existing Type", "Built-in Types|date", "item");
        
        
        addAttribute(opList3, "partNum", "Use Existing Type", "Simple Types|SKU", "item");

        JListOperator opList4 = opMultiView.getColumnListOperator(5);
        opList4.selectItem("partNum");
        changeProperty("Use", "Required");
        
        
        
        addComplexType(opList, "USAddress", 0, 0);
        
        opList1 = opMultiView.getColumnListOperator(1);
        opList1.selectItem("USAddress");
        addElement(opList1, "name","Use Existing Type", "Built-in Types|string", "USAddress");
        
        addElement(opList1, "state","Use Existing Type", "Built-in Types|string", "USAddress");
        
        addElement(opList1, "city","Use Existing Type", "Built-in Types|string", "USAddress");
        
        addElement(opList1, "street","Use Existing Type", "Built-in Types|string", "USAddress");
        
        addElement(opList1, "zip","Use Existing Type", "Built-in Types|decimal", "USAddress");

        addAttribute(opList1, "country", "Use Existing Type", "Built-in Types|NMTOKEN", "USAddress");
        opList2 = opMultiView.getColumnListOperator(2);
        opList2.selectItem("country");
        changeProperty("Fixed Value", "US");
        
        
        addComplexType(opList, "PurchaseOrderType", 0, 0);
        
        opList1 = opMultiView.getColumnListOperator(1);
        opList1.selectItem("PurchaseOrderType");
        addElement(opList1, "shipTo", "Use Existing Type", "Complex Types|USAddress", "PurchaseOrderType");
        
        addElement(opList1, "billTo", "Use Existing Type", "Complex Types|USAddress", "PurchaseOrderType");
        
        addElementRef(opList1, "Elements|comment", "PurchaseOrderType");
        changeProperty("Min Occurs", "0");
        
        addElement(opList1, "items", "Use Existing Type", "Complex Types|Items", "PurchaseOrderType");
        
        addAttribute(opList1, "orderDate", "Use Existing Type", "Built-in Types|date", "PurchaseOrderType");
        
        addElement(opList, "purchaseOrder", "Use Existing Type", "Complex Types|PurchaseOrderType", "no");

        Helpers.waitNoEvent();

        tearDown();
        
        checkSourceCRC();
        
    }
    
    private void changeProperty(String name, String value){
        Property prop = new Property(pso, name);
        prop.setValue(value);
        
    }
    
    private void customizeSimpleType(JListOperator opList, String tree){
        opList.selectItem("Simple Type");
        Point p = opList.getClickPoint(opList.getSelectedIndex());
        opList.clickForPopup(p.x, p.y);
        new JPopupMenuOperator().pushMenuNoBlock("Customize");
        Helpers.waitNoEvent();
        
        JDialogOperator opCustomizer = new JDialogOperator();
        
        JTreeOperator opTree = new JTreeOperator(opCustomizer);
        TreePath treePath = opTree.findPath(tree);
        opTree.selectPath(treePath);
        new JButtonOperator(opCustomizer, "OK").pushNoBlock();
        Helpers.waitNoEvent();
    }
    
    private void addAnnotation(JListOperator opList, String parent){
        opList.selectItem(parent);
        Point p = opList.getClickPoint(opList.getSelectedIndex());
        opList.clickForPopup(p.x, p.y);
        new JPopupMenuOperator().pushMenuNoBlock("Add|Annotation");
        Helpers.waitNoEvent();
    }
    
    private void addDocumentation(JListOperator opList){
        opList.selectItem("Annotation");
        Point p = opList.getClickPoint(opList.getSelectedIndex());
        opList.clickForPopup(p.x, p.y);
        new JPopupMenuOperator().pushMenuNoBlock("Add|Documentation");
        Helpers.waitNoEvent();
    }
    
    private void addAttribute(JListOperator opList, String name, String type, String tree, String parent){
        if (parent == "no") {
            opList.selectItem("Elements");
            Point p = opList.getClickPoint(opList.getSelectedIndex());
            opList.clickForPopup(p.x, p.y);
            new JPopupMenuOperator().pushMenuNoBlock("Add Attribute...");
            Helpers.waitNoEvent();
        } else {
            opList.selectItem(parent);
            Point p = opList.getClickPoint(opList.getSelectedIndex());
            opList.clickForPopup(p.x, p.y);
            new JPopupMenuOperator().pushMenuNoBlock("Add|Attribute...");
            Helpers.waitNoEvent();
        }
        
        JDialogOperator opCustomizer = new JDialogOperator();
        
        new JTextFieldOperator(opCustomizer, 0).setText(name);
        Helpers.waitNoEvent();
        
        new JRadioButtonOperator(opCustomizer, type).pushNoBlock();
        Helpers.waitNoEvent();
        
        if (tree != "no") {
            JTreeOperator opTree = new JTreeOperator(opCustomizer);
            TreePath treePath = opTree.findPath(tree);
            opTree.selectPath(treePath);
        }
        
        new JButtonOperator(opCustomizer, "OK").pushNoBlock();
        Helpers.waitNoEvent();
    }
    
    
    
    private void addElement(JListOperator opList, String name, String type, String tree, String parent){
        if (parent == "no") {
            opList.selectItem("Elements");
            Point p = opList.getClickPoint(opList.getSelectedIndex());
            opList.clickForPopup(p.x, p.y);
            new JPopupMenuOperator().pushMenuNoBlock("Add Element...");
            Helpers.waitNoEvent();
        } else {
            opList.selectItem(parent);
            Point p = opList.getClickPoint(opList.getSelectedIndex());
            opList.clickForPopup(p.x, p.y);
            new JPopupMenuOperator().pushMenuNoBlock("Add|Element...");
            Helpers.waitNoEvent();
        }
        
        JDialogOperator opCustomizer = new JDialogOperator();
        
        new JTextFieldOperator(opCustomizer, 0).setText(name);
        Helpers.waitNoEvent();
        
        new JRadioButtonOperator(opCustomizer, type).pushNoBlock();
        Helpers.waitNoEvent();
        
        if (tree != "no") {
            JTreeOperator opTree = new JTreeOperator(opCustomizer);
            TreePath treePath = opTree.findPath(tree);
            opTree.selectPath(treePath);
        }
        
        new JButtonOperator(opCustomizer, "OK").pushNoBlock();
        Helpers.waitNoEvent();
    }
    
    
    private void addElementRef(JListOperator opList, String tree, String parent){
        opList.selectItem(parent);
        Point p = opList.getClickPoint(opList.getSelectedIndex());
        opList.clickForPopup(p.x, p.y);
        new JPopupMenuOperator().pushMenuNoBlock("Add|Element Reference...");
        Helpers.waitNoEvent();
        
        JDialogOperator opCustomizer = new JDialogOperator();
        
        JTreeOperator opTree = new JTreeOperator(opCustomizer);
        TreePath treePath = opTree.findPath(tree);
        opTree.selectPath(treePath);
        
        new JButtonOperator(opCustomizer, "OK").pushNoBlock();
        Helpers.waitNoEvent();
    }
    
    
    private void addComplexType(JListOperator opList, String name, int type, int compositor){
        opList.selectItem("Complex Types");
        Point p = opList.getClickPoint(opList.getSelectedIndex());
        opList.clickForPopup(p.x, p.y);
        new JPopupMenuOperator().pushMenuNoBlock("Add Complex Type");
        Helpers.waitNoEvent();
        
        JDialogOperator opCustomizer = new JDialogOperator();
        
        new JTextFieldOperator(opCustomizer, 0).setText(name);
        Helpers.waitNoEvent();
        
        new JRadioButtonOperator(opCustomizer, "Sequence").pushNoBlock();
        Helpers.waitNoEvent();
        
        new JRadioButtonOperator(opCustomizer, "Inline Definition").pushNoBlock();
        Helpers.waitNoEvent();
        
        new JButtonOperator(opCustomizer, "OK").pushNoBlock();
        Helpers.waitNoEvent();
    }
    
    private void addSimpleType(JListOperator opList, String name){
        opList.selectItem("Simple Types");
        Point p = opList.getClickPoint(opList.getSelectedIndex());
        opList.clickForPopup(p.x, p.y);
        new JPopupMenuOperator().pushMenuNoBlock("Add Simple Type");
        Helpers.waitNoEvent();
        
        JDialogOperator opCustomizer = new JDialogOperator();
        
        new JTextFieldOperator(opCustomizer, 0).setText(name);
        Helpers.waitNoEvent();
        
        new JButtonOperator(opCustomizer, "OK").pushNoBlock();
        Helpers.waitNoEvent();
    }
    
    private void createSchema(){
        NewFileWizardOperator wizard = NewFileWizardOperator.invoke();
        wizard.selectCategory("XML");
        wizard.selectFileType("XML Schema");
        wizard.next();
        wizard.finish();
    }
    
    private void openSchema(){
        ProjectsTabOperator pto = ProjectsTabOperator.invoke();
        ProjectRootNode nodeProjectRoot = pto.getProjectRootNode("XSDTestProject");
        nodeProjectRoot.select();
        Node nodeXSD = new Node(nodeProjectRoot, "Source Packages|default package|newXmlSchema" + SCHEMA_EXTENSION);
        nodeXSD.callPopup().pushMenu("Open");
        
    }
    
    public void tearDown() {
        new SaveAllAction().performAPI();
    }
    
    private void checkSourceCRC() {
        startTest();
        
        final long goldenCRC32 = 3370014472L;
        
        SchemaMultiView opMultiView = new SchemaMultiView(SCHEMA_NAME);
        opMultiView.switchToSource();
        
        EditorOperator opEditor = new EditorOperator(SCHEMA_NAME);
        String strText = opEditor.getText();
        
        opMultiView.switchToSchema();
        
        strText = strText.replaceAll("[  [\t\f\r]] ", "");
        
        CRC32 crc32 = new CRC32();
        crc32.update(strText.getBytes());
        long checkSum = crc32.getValue();
        Helpers.writeJemmyLog("CRC32=" + checkSum);
        if ( checkSum != goldenCRC32) {
            fail("Schema source check sum doesn't match golden value");
        }
        
        endTest();
    }
    
}
