/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * ActivatedNodesControlAdapter.java
 *
 * Created on October 19, 2006, 2:03 PM
 *
 */

package org.netbeans.modules.xml.schema.refactoring.query.views;

import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.xml.nbprefuse.AnalysisConstants;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import prefuse.controls.ControlAdapter;
import prefuse.visual.VisualItem;

/**
 *
 * @author Ajit Bhate
 */
public class ActivatedNodesControlAdapter extends ControlAdapter {
    
    /** Creates a new instance of ActivatedNodesControlAdapter */
    public ActivatedNodesControlAdapter() {
    }
    
    public void itemReleased(VisualItem item, MouseEvent e) {
        super.itemReleased(item, e);
        setActivatedNodes(e, item);
    }

    private void setActivatedNodes(final MouseEvent e, final VisualItem item) {
        if (item.canGet(AnalysisConstants.OPENIDE_NODE, Node.class)) {
            Node node = (Node) item.get(AnalysisConstants.OPENIDE_NODE);
            if(node!=null) {
                Component c = e.getComponent();
                TopComponent tc = (TopComponent) SwingUtilities.
                        getAncestorOfClass(TopComponent.class,c);
                if (tc!=null) {
                    tc.setActivatedNodes(new Node[]{node});
                }
            }
        }
    }
    
}
