/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.text.syntax;

import java.util.MissingResourceException;

/**
 * Options for the java editor kit
 *
 * @author Libor Kramolis
 */
public class DTDPrintOptions extends org.netbeans.modules.editor.options.BasePrintOptions {

    /** Serial Version UID */
    private static final long serialVersionUID = 9083118813691632697L;

    public static final String DTD = "dtd"; // NOI18N


    public DTDPrintOptions () {
        this (DTDKit.class, DTD);
    }

    public DTDPrintOptions (Class kitClass, String typeName) {
        super (kitClass, typeName);
    }

    public String getString(String s) {
        try {
            return Util.THIS.getString (s);
        } catch (MissingResourceException e) {
            return super.getString (s);
        }
    }
}
