/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * BindingAndServiceConfigurationPanel.java
 *
 * Created on August 25, 2006, 2:51 PM
 */

package org.netbeans.modules.xml.wsdl.ui.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ComboBoxModel;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPQName;

import org.netbeans.modules.xml.wsdl.ui.view.wizard.ExtensibilityElementTemplateFactory;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.TemplateGroup;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.localized.LocalizedTemplate;
import org.netbeans.modules.xml.wsdl.ui.view.wizard.localized.LocalizedTemplateGroup;

/**
 *
 * @author  radval
 */
public class BindingConfigurationPanel extends javax.swing.JPanel {
    
    public static final String PROP_BINDING_TYPE = "PROP_BINDING_TYPE";
    public static final String PROP_BINDING_SUBTYPE = "PROP_BINDING_SUBTYPE";
            
    private ExtensibilityElementTemplateFactory factory;
    private Vector<LocalizedTemplateGroup> protocols = new Vector<LocalizedTemplateGroup>();
    private LocalizedTemplateGroup defaultSelection; //Select SOAP as default
    
    /** Creates new form BindingAndServiceConfigurationPanel */
    public BindingConfigurationPanel() {
        factory = new ExtensibilityElementTemplateFactory();
        Collection<TemplateGroup> groups = factory.getExtensibilityElementTemplateGroups();
        protocols = new Vector<LocalizedTemplateGroup>();
        
        SortedSet<LocalizedTemplateGroup> set = new TreeSet<LocalizedTemplateGroup>();
        for (TemplateGroup group : groups) {
            LocalizedTemplateGroup ltg = factory.getLocalizedTemplateGroup(group);
            if (ltg.getNamespace().equals(SOAPQName.SOAP_NS_URI)) {
                defaultSelection = ltg;
            }
            set.add(ltg);
        }
        
        protocols.addAll(set);
        
        initComponents();
        initGUI();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        bindingNameTextField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        bindingTypeComboBox = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        serviceNameTextField = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        servicePortTextField = new javax.swing.JTextField();

        jLabel1.setLabelFor(bindingNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(BindingConfigurationPanel.class, "BindingConfigurationPanel.jLabel1.text"));

        jLabel2.setLabelFor(bindingTypeComboBox);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(BindingConfigurationPanel.class, "BindingConfigurationPanel.jLabel2.text"));

        DefaultComboBoxModel model = new DefaultComboBoxModel(protocols);
        model.setSelectedItem(defaultSelection);
        bindingTypeComboBox.setModel(model);
        bindingTypeComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bindingTypeComboBoxActionPerformed(evt);
            }
        });

        jLabel3.setLabelFor(jPanel1);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(BindingConfigurationPanel.class, "BindingConfigurationPanel.jLabel3.text"));

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.X_AXIS));

        jLabel4.setLabelFor(serviceNameTextField);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(BindingConfigurationPanel.class, "BindingConfigurationPanel.jLabel4.text"));

        jLabel5.setLabelFor(servicePortTextField);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(BindingConfigurationPanel.class, "BindingConfigurationPanel.jLabel5.text"));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel1)
                    .add(jLabel2)
                    .add(jLabel3)
                    .add(jLabel4)
                    .add(jLabel5))
                .add(18, 18, 18)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 274, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, bindingTypeComboBox, 0, 274, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, bindingNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 274, Short.MAX_VALUE)
                    .add(serviceNameTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 274, Short.MAX_VALUE)
                    .add(servicePortTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 274, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(bindingNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(bindingTypeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jLabel3)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 14, Short.MAX_VALUE))
                .add(8, 8, 8)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(serviceNameTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel5)
                    .add(servicePortTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(106, 106, 106))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void bindingTypeComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bindingTypeComboBoxActionPerformed
        setBindingSubType(getBindingType());
        this.firePropertyChange(PROP_BINDING_TYPE, null, getBindingType());
    }//GEN-LAST:event_bindingTypeComboBoxActionPerformed
    
    public String getBindingName() {
        return this.bindingNameTextField.getText();
    }
    
    public void setBindingName(String bindingName) {
        this.bindingNameTextField.setText(bindingName);
    }
    
    public LocalizedTemplateGroup getBindingType() {
        return (LocalizedTemplateGroup) bindingTypeComboBox.getSelectedItem();
    }
    
    public void setBindingType(String bindingSubType) {
        this.bindingTypeComboBox.setSelectedItem(bindingSubType);
    }
    
    public LocalizedTemplate getBindingSubType() {
        return subTypePanel.getBindingSubType();
    }
    
    private void setBindingSubType(LocalizedTemplateGroup bindingType) {
        subTypePanel.reset(bindingType);
    }
    
    public String getServiceName() {
        return serviceNameTextField.getText();
    }
    
    public void setServiceName(String serviceName) {
        this.serviceNameTextField.setText(serviceName);
    }
    
    public String getServicePortName() {
        return servicePortTextField.getText();
    }
    
    public void setServicePortName(String servicePortName) {
        this.servicePortTextField.setText(servicePortName);
    }
    
    public JTextField getBindingNameTextField() {
        return this.bindingNameTextField;
    }
    
    public JTextField getServiceNameTextField() {
        return this.serviceNameTextField;
    }
    
    public JTextField getServicePortTextField() {
        return this.servicePortTextField;
    }
    
    
    private void initGUI() {
        if (protocols.size() > 0) {
            subTypePanel = new BindingSubTypePanel(defaultSelection,  new BindingSubTypeActionListener());
            jPanel1.add(subTypePanel);
        }
    }
    
    class BindingSubTypeActionListener implements ActionListener {
    	
    	public void actionPerformed(ActionEvent e) {
    		firePropertyChange(PROP_BINDING_SUBTYPE, null, getBindingSubType());
    	}
    	
    }
    
    private BindingSubTypePanel subTypePanel;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField bindingNameTextField;
    private javax.swing.JComboBox bindingTypeComboBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTextField serviceNameTextField;
    private javax.swing.JTextField servicePortTextField;
    // End of variables declaration//GEN-END:variables
    
}
