/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * CommonMessagePanel.java
 *
 * Created on June 9, 2006, 4:59 PM
 */

package org.netbeans.modules.xml.wsdl.ui.view.common;

import java.awt.Color;
import java.awt.Graphics;

import javax.swing.ImageIcon;
import javax.swing.UIManager;

import org.openide.util.Utilities;

/**
 *
 * @author  skini
 */
public class CommonMessagePanel extends javax.swing.JPanel {
    private static Color nbErrorForeground;
    private static Color nbWarningForeground;
    private boolean mValidState = false;

    static {//Got this from WizardDescriptor
        nbErrorForeground = UIManager.getColor("nb.errorForeground"); //NOI18N
        if (nbErrorForeground == null) {
            nbErrorForeground = new Color(255, 0, 0); // RGB suggested by jdinga in #65358
        }
        nbWarningForeground = UIManager.getColor("nb.errorForeground"); //NOI18N
        if (nbWarningForeground == null) {
            nbWarningForeground = new Color(255, 0, 0); // RGB suggested by jdinga in #65358
        }
        
    }
    /** Creates new form CommonMessagePanel */
    public CommonMessagePanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        m_lblMessage = new javax.swing.JLabel();

        m_lblMessage.setLabelFor(this);
        m_lblMessage.setToolTipText(org.openide.util.NbBundle.getMessage(CommonMessagePanel.class, "CommonMessagePanel.m_lblMessage.toolTipText")); // NOI18N
        m_lblMessage.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CommonMessagePanel.class, "CommonMessagePanel.m_lblMessage.AccessibleContext.accessibleName")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(m_lblMessage, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 390, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(m_lblMessage)
        );
    }// </editor-fold>//GEN-END:initComponents
    public void setErrorMessage(String errorMsg) {
        m_lblMessage.setText(errorMsg);
        m_lblMessage.setForeground (nbErrorForeground);
        m_lblMessage.repaint();
        m_lblMessage.setIcon(new ImageIcon(Utilities.loadImage("org/openide/resources/error.gif")));
        mValidState = false;
    }
    
    public void setWarningMessage(String warningMsg) {
        m_lblMessage.setText(warningMsg);
        m_lblMessage.setForeground (nbWarningForeground);
        m_lblMessage.repaint();
        m_lblMessage.setIcon(new ImageIcon (Utilities.loadImage ("org/openide/resources/warning.gif")));
        mValidState = true;
    }
    
    public void setMessage(String msg) {
        m_lblMessage.setText(msg);
        m_lblMessage.setIcon(null);
        mValidState = true;
    }
    
    public boolean isStateValid() {
    	return mValidState;
    }
    public void paint(Graphics g) {
        super.paint(g);
        //Graphics2D g2d = (Graphics2D)g;
        
        //g2d.drawLine(0, this.getHeight()-1, this.getWidth(), this.getHeight()-1);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel m_lblMessage;
    // End of variables declaration//GEN-END:variables
    
}
