/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions;

import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TwoStateHoverProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class HoverActionProvider {

    private WidgetAction mHoverAction;
    private static HoverActionProvider mHoverActionProvider;
    
    private HoverActionProvider(Scene scene) {
        if (mHoverAction == null) {
            mHoverAction = ActionFactory.createHoverAction(new MyHoverProvider(scene));
            scene.getActions().addAction(mHoverAction);
        }
    }

    public static HoverActionProvider getDefault(Scene scene) {
        if (mHoverActionProvider != null) return mHoverActionProvider;
        mHoverActionProvider = new HoverActionProvider(scene);
        return mHoverActionProvider;
    }
    
    public WidgetAction getHoverAction() {
        assert mHoverActionProvider != null : "Call getDefault before calling getHoverAction";
        return mHoverAction;
    }
    private static class MyHoverProvider implements TwoStateHoverProvider {

        private Scene scene;

        public MyHoverProvider (Scene scene) {
            this.scene = scene;
        }

        public void unsetHovering (Widget widget) {
            if (widget != null) {
                widget.setBackground (scene.getLookFeel().getBackground (ObjectState.createNormal ()));
                widget.setForeground (scene.getLookFeel ().getForeground (ObjectState.createNormal ()));
            }
        }

        public void setHovering (Widget widget) {
            if (widget != null) {
                ObjectState state = ObjectState.createNormal ().deriveObjectHovered (true);
                widget.setBackground (scene.getLookFeel ().getBackground (state));
                widget.setForeground (scene.getLookFeel ().getForeground (state));
            }
        }
    }
}
