/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory.SerialAlignment;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.layout.SerialLayout;

public class OneSideJustifiedLayout implements Layout {
    
    int gap = 0;
    int otherGap = 0;
    boolean isRightSided = false;
    
    SerialLayout layout;
    
    /**
     * if isRightSided is true, the first widget is expanded, such that it occupies remaining space in parent.
     * else the second widget is expanded.
     * 
     * 
     * Increases the height of the second widget by heightIncrease.
     * 
     * 
     * @param isRightSided
     * @param gap specifies the gap between widget
     * @param heightIncrease
     */
    public OneSideJustifiedLayout(boolean isRightSided, int gap, int heightIncrease) {
        this.isRightSided = isRightSided;
        this.gap = gap;
        this.otherGap = heightIncrease;
        layout = new SerialLayout(false, SerialAlignment.JUSTIFY, gap);
    }
    
    
    /**
     * if isRightSided is true, the first widget is expanded, such that it occupies remaining space in parent.
     * else the second widget is expanded.
     * 
     * Increases the height of the second widget by heightIncrease.
     * 
     * @param isRightSided
     * @param heightIncrease
     */
    public OneSideJustifiedLayout(boolean isRightSided, int heightIncrease) {
        this(isRightSided, 0, heightIncrease);
    }

    /**
     * if isRightSided is true, the first widget is expanded, such that it occupies remaining space in parent.
     * else the second widget is expanded.
     * 
     * @param isRightSided
     */
    public OneSideJustifiedLayout(boolean isRightSided) {
        this(isRightSided, 0, 0);
    }
    
    
    public void justify(Widget widget) {
        
        List<Widget> children = widget.getChildren();
        assert children.size() == 2 : "this layout cannot take more than 2 child widgets";

        layout.justify(widget);
        
        Widget first = children.get(0);
        Widget second = children.get(1);
        
        Rectangle parentBounds = widget.getClientArea();
        //adjust width of first widget to be justified
        
        Rectangle firstBounds = first.getBounds();
        Point firstLocation = first.getLocation();
        
        Rectangle secondBounds = second.getBounds();
        Point secondLocation = second.getLocation();
        
        int width = parentBounds.width - secondBounds.width;
        
        
        firstBounds.width = width;
        
        if (isRightSided) {
            secondLocation.x = width - secondBounds.x;
            first.resolveBounds(firstLocation, firstBounds);
            second.resolveBounds(secondLocation, secondBounds);
        } else {
            secondLocation.x = secondBounds.width - secondBounds.x;
            firstLocation.x += secondBounds.x;
            first.resolveBounds(secondLocation, firstBounds);
            second.resolveBounds(firstLocation, secondBounds);
        }
        
    }

    public void layout(Widget widget) {
        layout.layout(widget);
    }

    public boolean requiresJustification(Widget widget) {
        return true;
    }

}
