/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;

import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;

public class CenteredLabelWidget extends LabelWidget {

    protected static final int MINIMUM_WIDTH = 200;
    protected static final int MINIMUM_HEIGHT = 25;
    private Color mColor;
    
    public CenteredLabelWidget(Scene scene) {
        super(scene);
        init();
    }
    
    public CenteredLabelWidget(Scene scene, String text, Color color) {
        super(scene, text);
        mColor = color;
        init();
    }
    
    void init() {
        setAlignment(Alignment.CENTER);
        setVerticalAlignment(VerticalAlignment.CENTER);
        setMinimumSize(new Dimension(MINIMUM_WIDTH, MINIMUM_HEIGHT));
    }

    @Override
    protected void paintWidget() {
        if (mColor != null) {
            Graphics2D gr = getGraphics ();
            Color c = gr.getColor();
            gr.setColor(mColor);
            gr.fill(getClientArea());
            gr.setColor(c);
        }
        super.paintWidget();
    }
    

}
