/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * Created on Jun 3, 2005
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.netbeans.modules.xml.wsdl.ui.view.treeeditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.ui.cookies.WSDLElementCookie;
import org.openide.nodes.Node;


/**
 * @author radval
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public abstract class WSDLElementChildren extends AbstractChildren {
    
    
    public WSDLElementChildren(WSDLComponent element) {
        super(element);
    }
    
    @SuppressWarnings("unchecked")
    protected Collection getKeys() {
        
        WSDLComponent element = getWSDLComponent();
        if(element != null) {
            ArrayList keys = new ArrayList();
            
            List children = element.getChildren();
            if(children != null) {
                keys.addAll(children);
            }
            return keys;
        }
        
        return Collections.EMPTY_LIST;
    }
    
    @SuppressWarnings("unchecked")
    protected void refreshChildren() {
        //at the start of the list
        List keys = new ArrayList();
        keys.addAll(getKeys());
        this.setKeys(keys);
    }
    
        
    
    public Node getChildNode(Object element) {
        Node childNode = null;
        
        Enumeration enu = this.nodes();
        while(enu.hasMoreElements()) {
            Node child = (Node) enu.nextElement();
            WSDLElementCookie cookie = (WSDLElementCookie) child.getCookie(WSDLElementCookie.class);
            if(cookie != null && element.equals(cookie.getWSDLComponent())) {
                childNode = child;
                break;
            }
        }
        
        return childNode;
    }
    

    
}
