/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElements;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;


public class CreateBindingFromPortTypeWizardPanel1 implements WizardDescriptor.ValidatingPanel, ChangeListener{
    
    /**
     * The visual component that displays this panel. If you need to access the
     * component from this class, just use getComponent().
     */
    private CreateBindingFromPortTypeVisualPanel1 component;
    
    
    
    private WizardDescriptor wiz = null;
    
    private PortType mPortType = null;
    
    private WSDLExtensibilityElements mElements;
    
    public CreateBindingFromPortTypeWizardPanel1(PortType portType, WSDLExtensibilityElements elements) {
        mPortType = portType;
        mElements = elements;
    }
    
    // Get the visual component for the panel. In this template, the component
    // is kept separate. This can be more efficient: if the wizard is created
    // but never displayed, or not all panels are displayed, it is better to
    // create only those which really need to be visible.
    public CreateBindingFromPortTypeVisualPanel1 getComponent() {
        if (component == null) {
            component = new CreateBindingFromPortTypeVisualPanel1(mPortType, mElements);
        }
        component.addChangeListener(this);
        return component;
    }
    
    public HelpCtx getHelp() {
        // Show no Help button for this panel:
        return HelpCtx.DEFAULT_HELP;
        // If you have context help:
        // return new HelpCtx(SampleWizardPanel1.class);
    }
    
    public boolean isValid() {
        // If it is always OK to press Next or Finish, then:

        String errorMessage = getAnyErrors();
        wiz.putProperty ("WizardPanel_errorMessage", errorMessage); // NOI18N
        return errorMessage == null;
        // If it depends on some condition (form filled out...), then:
        // return someCondition();
        // and when this condition changes (last form field filled in...) then:
        // fireChangeEvent();
        // and uncomment the complicated stuff below.
    }
    
    private String getAnyErrors() {
        String errorMessage = null;
        errorMessage = validateOperations();
        errorMessage = validateBindingName();
        return errorMessage;
    }
    
    private String validateBindingName() {
        String bindingName = component.getBindingName();

        if (NameGenerator.getInstance().isBindingExists(bindingName, mPortType.getModel())) {
            return NbBundle.getMessage(CreateBindingFromPortTypeWizardPanel1.class, "CreateBindingFromPortTypeWizardPanel1_BINDING_NAME_EXISTS", new Object[] {bindingName});
        }
        return null;
        
    }
    
    private String validateOperations() {
        
        Object[] operations = component.getSelectedOperations();
        if (operations == null || operations.length == 0) {
            return NbBundle.getMessage(CreateBindingFromPortTypeWizardPanel1.class, "CreateBindingFromPortTypeWizardPanel1_SELECT_OPERATIONS");
        }
        return null;
    }
    
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);
    public final void addChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.add(l);
        }
    }
    public final void removeChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.remove(l);
        }
    }
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        synchronized (listeners) {
            it = new HashSet<ChangeListener>(listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }
     
    
    // You can use a settings object to keep track of state. Normally the
    // settings object will be the WizardDescriptor, so you can use
    // WizardDescriptor.getProperty & putProperty to store information entered
    // by the user.
    public void readSettings(Object settings) {
        wiz = (WizardDescriptor) settings;
    }
    public void storeSettings(Object settings) {
        if ( WizardDescriptor.PREVIOUS_OPTION.equals( ((WizardDescriptor)settings).getValue() ) ) {
            return;
        }
        if (isValid()) {
            ;
        }
        component.storeValues((WizardDescriptor) settings);
    }



    public void stateChanged(ChangeEvent e) {
          isValid();
        
    }

    public void validate() throws WizardValidationException {
       String errorMessage = validateBindingName();
       if (errorMessage != null) {
           throw new WizardValidationException(component.getBindingNameComponent(), errorMessage, errorMessage);
       }
       
       errorMessage = validateOperations();
       if (errorMessage != null) {
           throw new WizardValidationException(component.getOperationsComponent(), errorMessage, errorMessage);
       }
        
    }
    
}

