/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.wsdl.ui.wsdl.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.CategorizedSchemaNodeFactory;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;



/**
 * @author radval
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class XSDTypesNode extends FilterNode {
   
    private Collection mSchemas;
    
    
    public XSDTypesNode(Node typesNode, Collection schemas) {
        super(typesNode);
        mSchemas = schemas;
        this.setDisplayName(NbBundle.getMessage(XSDTypesNode.class, "INLINE_SCHEMATYPE_NAME"));
        this.setChildren(new XSDTypesChildren());
    }
    
    public XSDTypesNode(Node typesNode, Collection schemas, List<Class<? extends SchemaComponent>> filters) {
        super(typesNode);
        mSchemas = schemas;
        this.setDisplayName(NbBundle.getMessage(XSDTypesNode.class, "INLINE_SCHEMATYPE_NAME"));
        this.setChildren(new XSDTypesChildren(filters));
    }

    public class XSDTypesChildren extends Children.Keys {
        private List<Class<? extends SchemaComponent>> filters;
        public XSDTypesChildren(List<Class<? extends SchemaComponent>> filters) {
            this.filters = filters;
        }
        
        public XSDTypesChildren() {
        }
        
        @Override
        protected Node[] createNodes(Object key) {
            if (filters == null) {
                filters = new ArrayList<Class<? extends SchemaComponent>>();
                filters.add(GlobalSimpleType.class);
                filters.add(GlobalComplexType.class);
                filters.add(GlobalElement.class);
                filters.add(SchemaModelReference.class);
            }
            CategorizedSchemaNodeFactory factory = new CategorizedSchemaNodeFactory(
                    ((Schema)key).getModel(), filters, Lookup.EMPTY);
            Node node = factory.createNode((Schema) key);
            return new Node[] { node };

        }
        
        
        @Override
        protected void addNotify() {
            resetKeys();
        }
        
        @Override
        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            
        }
        
        private void resetKeys() {
                this.setKeys(mSchemas);
        }
        
        @Override
        public boolean remove (final Node[] arr) {
            //HACK: we want to reset the keys
            //and also want to call super.remove
            //so that tree gets refreshed.
            //we need to add resetkeys
            //because when nodes are created from 
            //persisted bpel info
            //super.remove() does not delete a node.(it is not in nodes collection)
            //supper.remove() removes node when user create
            //a new node for the first time. So we need both here.
            resetKeys();
            return super.remove(arr);
        }
    }

}
