/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.xam.ui.customizer;

import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.Utilities;

/**
 *
 * @author  Ajit Bhate
 */
public class MessagePanel extends javax.swing.JPanel implements MessageDisplayer
{
	static final long serialVersionUID = 1L;
	
	/** Creates new form MessagePanel */
	public MessagePanel()
	{
		initComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        panel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        panel.setLayout(null);

        GroupLayout panelLayout = new GroupLayout(panel);
        panel.setLayout(panelLayout);
        panelLayout.setAutocreateGaps(true);
        panelLayout.setAutocreateContainerGaps(true);
        GroupLayout.ParallelGroup hGroup =
        panelLayout.createParallelGroup();
        panelLayout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup =
        panelLayout.createSequentialGroup();
        panelLayout.setVerticalGroup(vGroup);
        add(panel, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents

	public void annotate(String message, MessageDisplayer.Type type)
	{
		if(!isVisible()) setVisible(true);
		JLabel messageLabel = new JLabel(message);
		switch(type)
		{
			case ERROR:
				messageLabel.setIcon(new ImageIcon(Utilities.loadImage(
						"org/openide/resources/error.gif"))); // NOI18N
				break;
			case WARNING:
				messageLabel.setIcon(new ImageIcon(Utilities.loadImage(
						"org/openide/resources/warning.gif"))); // NOI18N
				break;
			case INFO:
			default:
		}
		GroupLayout layout = (GroupLayout)panel.getLayout();
		((GroupLayout.ParallelGroup)layout.getHorizontalGroup()).add(messageLabel);
		((GroupLayout.SequentialGroup)layout.getVerticalGroup()).add(messageLabel);
	}

	public void clear()
	{
		remove(panel);
		initComponents();
		setVisible(false);
	}

	public JComponent getComponent()
	{
		return this;
	}
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel panel;
    // End of variables declaration//GEN-END:variables
	
}
