/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.xdm.visitor;

import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.NamedNodeMap;

/**
 * This class provides the ability to walk nodes which have children.
 * @author Chris Webster
 */
public class ChildVisitor extends DefaultVisitor {
    
    protected void visitNode(Node container) {
	NodeList children = container.getChildNodes();
	for (int i =0; i<children.getLength(); i++) {
	    Node l = (Node)children.item(i);
	    l.accept(this);
	}
	NamedNodeMap attributes = container.getAttributes();
	for (int i =0; i<attributes.getLength(); i++) {
	    Node l = (Node)attributes.item(i);
	    l.accept(this);
	}
    }
}
