/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.xdm.visitor;

import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.w3c.dom.NodeList;


/**
 *
 * @author Chris Webster
 */
public class PrintVisitor extends ChildVisitor {
    
    public void visit(Attribute attr) {
        System.out.printf("attr: %s\n", attr.getValue());
    }
    
    public void visit(Document doc) {
        super.visit(doc);
    }
    
    public void visit(Element e) {
        System.out.printf("element %s\n", e.getLocalName());
        super.visit(e);
    }
    
    public void visit(Text txt) {
        System.out.printf("text %s\n", txt.getText());
	System.out.printf("node type %s\n", txt.getNodeName());
	System.out.printf("node value %s\n", txt.getNodeValue());
    }
    
}
