/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xslt.model.impl;


import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.XslComponent;
import org.netbeans.modules.xslt.model.XslModel;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import junit.framework.TestCase;


/**
 * @author ads
 *
 */
public class AbstractXslTestCase extends TestCase {
    
    public static final String TEST = "test.xsl";

    public AbstractXslTestCase(String testName) {
        super(testName);
    }

    protected void tearDown() throws Exception {
        TestCatalogModel.getDefault().clearDocumentPool();
    }
    
    protected void log( String str ) {
        System.out.println( str );
    }
    
    protected Stylesheet getStyleSheet( String resourse ) {
        return getStyleSheet(resourse , false);
    }
    
    protected Stylesheet getStyleSheet( String resourse , boolean reload) {
        if ( !reload && myStylesheet != null ) {
            return myStylesheet;
        }
        try {
            XslModel model = Utils.loadXslModel( resourse , reload );
            myStylesheet = model.getStylesheet(); 
            return myStylesheet;
        }
        catch (Exception e) {
            RuntimeException exc = new RuntimeException( e );
            throw exc;
        }
    }
    
    protected String getContent( XslModel model ) {
        Document doc = (Document)model.getModelSource().getLookup().lookup( 
                Document.class );
        assert doc != null;
        String str = null ;
        try {
            str = doc.getText( 0, doc.getLength() );
        }
        catch (BadLocationException e) {
            assert false;
        }
        return str;
    }
    
    protected org.w3c.dom.Document getDOMDocument( XslModel model ) 
    {
        //model.getAccess().flush();
        
        Exception exception = null;
        try {
            String str = getContent(model);
            DocumentBuilder builder =
                DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return builder.parse( new InputSource( new StringReader( str )) );
        }
        catch (ParserConfigurationException e) {
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        if ( exception != null ) {
            AssertionError error = new AssertionError( );
            error.initCause( exception );
            throw error;
        }
        return null;
    } 
    
    protected XslModel getModel() {
        return myStylesheet.getModel();
    }
    
    protected List<String> getChildrenTags( List<? extends XslComponent> list ){
        List<String> ret = new ArrayList<String>( list.size() );
        for (XslComponent component : list) {
            String name = component.getPeer().getNodeName();
            /*String name = component.getComponentType().toString().toLowerCase();
            assert name.indexOf( "-" )!=-1;*/
            ret.add( name );
        }
        return ret;
    }
    
    private Stylesheet myStylesheet;
    
}
