/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.List;

import org.netbeans.modules.xslt.model.Key;
import org.netbeans.modules.xslt.model.Output;
import org.netbeans.modules.xslt.model.Param;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.StylesheetChild;
import org.netbeans.modules.xslt.model.Template;
import org.netbeans.modules.xslt.model.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * @author ads
 *
 */
public class StyleheetTest extends AbstractXslTestCase {
    
    public StyleheetTest( String testName ) {
        super(testName);
    }
    
    public void testGetStylesheetChildren() {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        List<StylesheetChild> list = stylesheet.getStylesheetChildren();
        
        assert list.size() == 7 ;
        
        assert list.get( 0 ).getComponentType() == Param.class;
        assert list.get( 1 ).getComponentType() == Output.class;
        assert list.get( 2 ).getComponentType() == Variable.class;
        assert list.get( 3 ).getComponentType() == Template.class;
        assert list.get( 4 ).getComponentType() == Template.class;
        assert list.get( 5 ).getComponentType() == Variable.class;
        assert list.get( 6 ).getComponentType() == Param.class;
    }
    
    public void testAppendStylesheetChild() {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        Template template = getModel().getFactory().createTemplate();
        
        List<String> children = getChildrenTags( 
                stylesheet.getStylesheetChildren() );
        
        getModel().startTransaction();
        stylesheet.appendStylesheetChild( template );
        getModel().endTransaction();
        
        Document doc = getDOMDocument( getModel() );
        
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        
        int count = 0; 
        assert list.getLength() > children.size();
        for( int i = 0 ; i< list.getLength(); i++ ) {
            Node next = list.item( i );
            if ( count == children.size() && next instanceof Element) {
                assert next.getNodeName().endsWith( 
                        template.getPeer().getNodeName() ): "Found "+
                        next.getNodeName()+" element, but expected :"+
                        template.getPeer().getNodeName();
                    
                break;
            }
            if ( next instanceof Element && 
                    !next.getNodeName().endsWith("import"))     // NOI18N 
            {
                assert next.getNodeName().equals( children.get( count )):
                "Found "+next.getNodeName()+" element, but expected : "+
                children.get( i );
                count++;
            }
        }
    }
    
    public void testRemoveStylesheetChild() {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        List<StylesheetChild> children = stylesheet.getStylesheetChildren();
        List<String> childrenNames = getChildrenTags( children );
        
        getModel().startTransaction();
        stylesheet.removeStylesheetChild( children.get( 0 ));
        getModel().endTransaction();
        
        childrenNames.remove( 0 );
        
        Document doc = getDOMDocument( getModel() );
        
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        
        int count = 0; 
        for( int i = 0 ; i< list.getLength(); i++ ) {
            Node next = list.item( i );
            if ( next instanceof Element && 
                    !next.getNodeName().endsWith("import"))     // NOI18N 
            {
                assert next.getNodeName().equals( childrenNames.get( count )):
                    "Found "+next.getNodeName()+" element, but expected : "+
                    childrenNames.get( count );
                count++;
            }
        }
    }
    
    public void testAddStylesheetChild() {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        List<StylesheetChild> children = stylesheet.getStylesheetChildren();
        List<String> childrenNames = getChildrenTags( children );
        
        Key key = getModel().getFactory().createKey();
        
        int position = 1;
        getModel().startTransaction();
        stylesheet.addStylesheetChild( key, position );
        getModel().endTransaction();
        
        Document doc = getDOMDocument( getModel() );
        
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        
        int count = 0; 
        boolean flag = true;
        for( int i = 0 ; i< list.getLength(); i++ ) {
            Node next = list.item( i );
            if ( count == position && next instanceof Element && flag ) {
                assert next.getNodeName().endsWith( key.getPeer().getNodeName() ):
                    "Found "+
                    next.getNodeName()+" element, but expected :"+
                    key.getPeer().getNodeName();
                    flag = false;
            }
            else if ( next instanceof Element && 
                    !next.getNodeName().endsWith("import"))     // NOI18N 
            {
                assert next.getNodeName().equals( childrenNames.get( count )):
                    "Found "+next.getNodeName()+" element, but expected : "+
                    childrenNames.get( count );
                count++;
            }
        }
    }
    
    // TODO : need to test import access.

}
