/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.List;

import org.netbeans.modules.xslt.model.ApplyTemplates;
import org.netbeans.modules.xslt.model.LiteralResultElement;
import org.netbeans.modules.xslt.model.SequenceElement;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.Template;


/**
 * @author ads
 *
 */
public class TemplateTest extends AbstractXslTestCase {

    public TemplateTest( String testName ) {
        super(testName);
    }
    
    public void testGetSequenceChildren() {
        Template template = get( 0 );
        
        List<SequenceElement> children = template.getSequenceChildren();
        
        assert children.size() == 2;
        
        assert children.get( 0 ).getComponentType() == ApplyTemplates.class;
        assert children.get( 1 ).getComponentType() == LiteralResultElement.class;
    }
    
    private Template get( int i ) {
        Stylesheet stylesheet = getStyleSheet( TEST );
        List<Template> templates = stylesheet.getChildren( Template.class );
        return templates.get(i);
    }

}
