/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xslt.model.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

import org.netbeans.modules.xslt.model.XslModel;
import org.netbeans.modules.xslt.model.resources.ResourceMarker;

/**
 *
 * @author ads
 */
public class Utils {
    
    public static File getTempDir(String path) throws Exception {
        File tempdir = new File(System.getProperty("java.io.tmpdir"), path);
        tempdir.mkdirs();
        return tempdir;
    }
    
    public static XslModel loadXslModel(String resourcePath) throws Exception {
        return  loadXslModel( resourcePath , false );
    }
    
    
    public static XslModel loadXslModel(String resourcePath, boolean reload) 
        throws Exception 
    {
        String location = resourcePath.substring(resourcePath.lastIndexOf('/')+1);
        URI locationURI = new URI(location);
        TestCatalogModel.getDefault().addURI(locationURI, 
                getResourceURI(resourcePath));
        return TestCatalogModel.getDefault().getXslModel(locationURI, reload);
    }
    
    public static XslModel loadXslModel(File schemaFile) throws Exception {
        URI locationURI = new URI(schemaFile.getName());
        TestCatalogModel.getDefault().addURI(locationURI, schemaFile.toURI());
        return TestCatalogModel.getDefault().getXslModel(locationURI);
    }
    
    public static URI getResourceURI(String path) throws RuntimeException {
        try {
            return ResourceMarker.class.getResource(path).toURI();
        } catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
    
    public static void setNewContent( XslModel model , String newContent ) 
        throws IOException 
    {
        Document doc = (Document) model.getModelSource().getLookup().
            lookup( Document.class );
        assert doc != null;
        try {
            doc.remove( 0 , doc.getLength());
            doc.insertString( 0 , newContent , null );
        }
        catch (BadLocationException e) {
            assert false;
        }
        model.sync();
    }
    
    public static void setNewContentFromFile( XslModel model , String fileName ) 
        throws IOException 
    {
        InputStream stream = ResourceMarker.class.getResourceAsStream( fileName );
        BufferedReader reader = new BufferedReader(new InputStreamReader( stream));
        StringBuilder builder = new StringBuilder();
        String nextLine = null;
        try {
            while( (nextLine = reader.readLine()) != null ) {
                builder.append( nextLine );
                builder.append(System.getProperty("line.separator"));
            }
        }
        finally {
            reader.close();
        }
        setNewContent(model, builder.toString() );
    }
}
