/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.List;

import org.netbeans.modules.xslt.model.LiteralResultElement;
import org.netbeans.modules.xslt.model.Stylesheet;
import org.netbeans.modules.xslt.model.Template;
import org.netbeans.modules.xslt.model.XslComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;




/**
 * @author ads
 *
 */
public class XslComponentTest extends AbstractXslTestCase {

    public XslComponentTest( String testName ) {
        super(testName);
    }

    public void testGetContent()  {
        Template template = getTemplate( 0 );
        
        assert template != null : "Couldn't found template child";
        
        Document doc = getDOMDocument( getModel() );
        NodeList list = doc.getElementsByTagName( template.getPeer().getNodeName() );
        
        assert list.getLength() == 2;
        
        assert template.getContent().trim().equals( getContent( list.item( 0 )) );
    }
    
    public void testSetContent()  {
        Template template = getTemplate( 0 );

        List<XslComponent> childrenList = template.getChildren();
        
        getModel().startTransaction();
        template.setContent( "a" );
        getModel().endTransaction();
        
        Document doc = getDOMDocument( getModel() );
        NodeList list = doc.getElementsByTagName( template.getPeer().getNodeName() );
        
        assert getContent( list.item( 0 ) ).equals( "a" );
        
        assert template.getContent().trim().equals( "a" );
        
        list = list.item( 0 ).getChildNodes();
        
        int count = 0;
        for( int i=0 ; i<list.getLength(); i++ ) {
            Node node = list.item( i );
            if ( node instanceof Element ) {
                node.getNodeName().equals( 
                        childrenList.get( count ).getPeer().getNodeName());
                count++;
            }
        }
    }
    
    public void testGetContentInEmpty() {
        Template template = getTemplate( 1 );
        
        String content = template.getContent();
        if ( content != null ) {
            assert content.trim().length() == 0;
        }
    }
    
    public void testSetContentInEmpty() {
        String text = "new";
        Template template = getTemplate( 1 );
        
        getModel().startTransaction();
        template.setContent( text );
        getModel().endTransaction();
        
        template.getContent().trim().equals( text );
        
        Document doc = getDOMDocument( getModel() );
        NodeList list = doc.getElementsByTagName( template.getPeer().getNodeName() );
        
        assert list.getLength() == 2;
        
        assert getContent( list.item( 1 )).equals( text );
        
        list = list.item( 1 ).getChildNodes();
        for( int i=0 ; i<list.getLength(); i++ ) {
            assert list.item( i ).getNodeType() == Node.TEXT_NODE;
        }
    }

    public void testGetTrailingText() {
        List<LiteralResultElement> children = 
            getTemplate( 0 ).getChildren( LiteralResultElement.class );
        
        LiteralResultElement element = children.get( 0 );
        assert element!= null;
        
        String text = element.getTrailingText();
        
        checkTrailingText(text);
        
    }

    public void testSetTrailingText() {
        String text = "new_text";
        
        List<LiteralResultElement> children = 
            getTemplate( 0 ).getChildren( LiteralResultElement.class );
        
        LiteralResultElement element = children.get( 0 );
        assert element!= null;
        
        getModel().startTransaction();
        element.setTrailingText(text);
        getModel().endTransaction();
        
        assert element.getTrailingText().trim().equals( text );
        
        checkTrailingText( text );
    }
    
    private void checkTrailingText( String text ) {
        Document doc = getDOMDocument( getModel() );
        NodeList list = doc.getElementsByTagName( 
                getTemplate( 0 ).getPeer().getNodeName() );
        
        Node node = list.item( 0 );
        list = node.getChildNodes();
        int count=0;
        StringBuilder builder = new StringBuilder();
        for( int i=0; i<list.getLength() ; i++ ) {
            Node next = list.item( i );
            if ( next instanceof Element ) {
                count++; 
            }
            if ( count >1 && 
                    ( next.getNodeType()== Node.TEXT_NODE 
                            || next.getNodeType()== Node.CDATA_SECTION_NODE ) )
            {
                builder.append( next.getNodeValue() );
            }
        }
        
        assert count == 2; // we should have only two elements here
        
        assert text.trim().equals( builder.toString().trim() );
    }
    
    private Template getTemplate( int i ) {
        Stylesheet stylesheet = getStyleSheet( TEST );
        
        List<Template> children = stylesheet.getChildren( Template.class );
        Template template = children.get( i );
        return template;
    }

    
    private String getContent( Node node ) {
        NodeList list = node.getChildNodes();
        StringBuilder builder = new StringBuilder();
        for( int i=0 ; i<list.getLength(); i++ ) {
            Node next = list.item( i );
            if ( next instanceof Element ) {
                break;
            }
            if ( next.getNodeType() == Node.TEXT_NODE || next.getNodeType() == 
                Node.CDATA_SECTION_NODE )
            {
                builder.append( next.getNodeValue() );
            }

        }
        return builder.toString().trim();
    }
}
