/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.lodgingsupplier.pomessagebean;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.*;
import javax.jms.*;
import javax.xml.rpc.*;

import com.sun.j2ee.blueprints.lodgingsupplier.JNDINames;
import com.sun.j2ee.blueprints.lodgingsupplier.powebservice.*;
import com.sun.j2ee.blueprints.lodgingsupplier.purchaseorder.ejb.*;
import com.sun.j2ee.blueprints.servicelocator.*;
import com.sun.j2ee.blueprints.servicelocator.ejb.*;

public class LodgingMessageBean implements MessageDrivenBean, MessageListener {

    private transient MessageDrivenContext mdc = null;

    /**
     * Default constructor.
     */
    public LodgingMessageBean() {}

    /**
     * Sets the context for this bean.
     */
    public void setMessageDrivenContext (MessageDrivenContext mdc) {
  this.mdc = mdc;
    }

    /**
     * Casts the incoming message to an ObjectMessage.
     */
    public void onMessage(Message message) {
        LodgingOrder lo = null;

        try {
      String messageID = message.getJMSMessageID();
            if (message instanceof ObjectMessage) {
                ObjectMessage msg = (ObjectMessage)message;
    lo = (LodgingOrder)msg.getObject();
      } else {
                System.out.println("Wrong type message: "
                                   + message.getClass().getName());
            }
        } catch (JMSException e) {
      // Proper exception handling as in OPC module has to be 
      // implemented here later
            e.printStackTrace();
        }

  try {
      doWork(lo);
  } catch (OrderSubmissionException oe) {
      // Proper exception handling as in OPC module has to be 
      // implemented here later
      oe.printStackTrace();
  }

    }

    public void doWork(LodgingOrder lodge) throws OrderSubmissionException {
  try {
      persistOrder(lodge);
  } catch (Exception e) {
      // Proper exception handling as in OPC module has to be 
      // implemented here later
      e.printStackTrace();
  }
  sendInvoice(lodge);
    }

    public void sendInvoice(LodgingOrder lodge) {
  Invoice inv = new Invoice("1234", lodge.getOrderId(), 
          "LODGING_INVOICE", "COMPLETED",
          lodge.getLodgingId().trim(),
          "1234 Main Street, Sometown 12345, USA",
          "No Cancelations 24 hours prior");
  try {
      InitialContext ic = new InitialContext();
      WebServiceBroker svc = (WebServiceBroker) 
    ic.lookup(JNDINames.BROKER_SERVICE_NAME);
      String endpointURI = (String) 
    ic.lookup(JNDINames.BROKER_SERVICE_URL);
      BrokerServiceIntf port= (BrokerServiceIntf)
                     svc.getPort(BrokerServiceIntf.class);

      // Required because we build the stubs using static WSDL
      ((Stub)port)._setProperty(Stub.ENDPOINT_ADDRESS_PROPERTY,
              endpointURI);
      port.submitDocument(inv.toXML());
  } catch (Exception ne) {
      // Proper exception handling as in OPC module has to be 
      // implemented here later
      ne.printStackTrace();
  }
    }
  

    /**
     * Persists the LodgingOrder
     */
    public void persistOrder(LodgingOrder lodge)
  throws OrderSubmissionException {

  try {
            ServiceLocator sl = new ServiceLocator();

            LodgingOrderLocalHome lodgeLocalHome = (LodgingOrderLocalHome)
                sl.getLocalHome(JNDINames.LODGE_ORDER_EJB);
            LodgingOrderLocal  lodgeLocal =
                (LodgingOrderLocal) lodgeLocalHome.create(lodge);
        } catch (ServiceLocatorException je) {
            throw new OrderSubmissionException("Error LODGE persisting order:"
                                               + je.getMessage());
        } catch(CreateException ce) {
            throw new OrderSubmissionException("Error LODGE persisting order:"
                                               + ce.getMessage());
        }
    }


    /**
     * Creates a bean.
     */
    public void ejbCreate() {}

    /**
     * Removes this bean.
     */
    public void ejbRemove() {
        mdc = null;
    }
}
