<%-- 
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
 --%>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="/WEB-INF/waftags.tld" prefix="waf" %>
<%@page contentType="text/html"%>

<fmt:setLocale value="en_US" />

<sql:setDataSource dataSource="jdbc/CatalogDB"/>

<sql:query var="lodgingDetails"> 
 select name, description, price,imageuri from lodging where lodgingid =  ? and locale = ?
 <sql:param>${cart.lodgingId}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>

<script language="javascript">
   function changePeople() {
       lodgingForm.submit();
   }
</script>

<form name="lodgingForm" method="POST" action="cart.do" >
<input type="HIDDEN" name="target_action" value="update_lodging_room_count" />
<table  border="0" width="100%" cellspacing="0">
  <tr>
   <td>
     <c:url var="imageURL" value="images/${lodgingDetails.rows[0].imageuri}"/>
     <image src="${imageURL}" alt="${lodgingDetails.rows[0].name} Image">
   </td>
    <td  align="left">
    <h2>${lodgingDetails.rows[0].name}</h2>
      <br>${lodgingDetails.rows[0].description}
      
      <br><b>Number of Nights:</b> ${cart.lodgingDays}
      <br><b>Number of Rooms:</b>${cart.lodgingRoomCount}
       <br><br>
       <b>Price Per Room Per Night:</b><fmt:formatNumber value="${lodgingDetails.rows[0].price}" type="currency" />
   </td>
   </tr>
  <tr>
   <td colspan="3">
 <hr noshade="noshade">
   </td>
   </tr>
  <tr>
   <td colspan="2" align="left">
    <h2>Lodging Total:</h2>
    </td>
   <td align="right">
     <b><fmt:formatNumber value="${cartBean.lodgingTotal}" type="currency" /></b>
    </td>
  </tr>
  <tr>
    <td colspan="3" align="right">
        <br>
       <a href="lodgings.screen?tab=${param.tab}">Change Lodging</a>
  </tr>
 </table>
</form>
