/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;

public class PrivilegeNode
extends QueryTreeNode {
    public static final int TABLE_PRIVILEGES = 0;
    public static final int ROUTINE_PRIVILEGES = 1;
    private int objectType;
    private Object objectOfPrivilege;
    private TablePrivilegesNode specificPrivileges;

    public void init(Object object, Object object2, Object object3) {
        this.objectType = (Integer)object;
        this.objectOfPrivilege = object2;
        this.specificPrivileges = (TablePrivilegesNode)object3;
    }

    public QueryTreeNode bind(HashMap hashMap, List list, boolean bl) throws StandardException {
        TupleDescriptor tupleDescriptor = null;
        SchemaDescriptor schemaDescriptor = null;
        switch (this.objectType) {
            case 0: {
                TableName tableName = (TableName)this.objectOfPrivilege;
                schemaDescriptor = this.getSchemaDescriptor(tableName.getSchemaName(), true);
                if (schemaDescriptor.isSystemSchema()) {
                    throw StandardException.newException("2850F", tableName.getFullTableName());
                }
                TableDescriptor tableDescriptor = this.getTableDescriptor(tableName.getTableName(), schemaDescriptor);
                if (tableDescriptor == null) {
                    throw StandardException.newException("42X05", tableName);
                }
                if (this.isSessionSchema(schemaDescriptor.getSchemaName())) {
                    throw StandardException.newException("XCL51.S");
                }
                if (tableDescriptor.getTableType() != 0 && tableDescriptor.getTableType() != 2) {
                    throw StandardException.newException("2850F", tableName.getFullTableName());
                }
                if (list.contains(schemaDescriptor.getAuthorizationId())) {
                    throw StandardException.newException("2850F", tableDescriptor.getQualifiedName());
                }
                this.specificPrivileges.bind(tableDescriptor, bl);
                tupleDescriptor = tableDescriptor;
                break;
            }
            case 1: {
                RoutineDesignator routineDesignator = (RoutineDesignator)this.objectOfPrivilege;
                schemaDescriptor = this.getSchemaDescriptor(routineDesignator.name.getSchemaName(), true);
                if (!schemaDescriptor.isSchemaWithGrantableRoutines()) {
                    throw StandardException.newException("2850F", routineDesignator.name.getFullTableName());
                }
                AliasDescriptor aliasDescriptor = null;
                RoutineAliasInfo routineAliasInfo = null;
                List list2 = this.getDataDictionary().getRoutineList(schemaDescriptor.getUUID().toString(), routineDesignator.name.getTableName(), routineDesignator.isFunction ? (char)'F' : 'P');
                if (list.contains(schemaDescriptor.getAuthorizationId())) {
                    throw StandardException.newException("2850F", routineDesignator.name.getFullTableName());
                }
                if (routineDesignator.paramTypeList == null) {
                    if (list2.size() > 1) {
                        throw StandardException.newException(routineDesignator.isFunction ? "42X46" : "42X47", routineDesignator.name.getFullTableName());
                    }
                    if (list2.size() != 1) {
                        throw StandardException.newException("42Y03", routineDesignator.name.getFullTableName());
                    }
                    aliasDescriptor = (AliasDescriptor)list2.get(0);
                } else {
                    int n;
                    boolean bl2 = false;
                    block4: for (int i = list2.size() - 1; !bl2 && i >= 0; --i) {
                        aliasDescriptor = (AliasDescriptor)list2.get(i);
                        routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                        n = routineAliasInfo.getParameterCount();
                        if (n != routineDesignator.paramTypeList.size()) continue;
                        TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
                        bl2 = true;
                        for (int j = 0; j < n; ++j) {
                            if (typeDescriptorArray[j].equals(routineDesignator.paramTypeList.get(j))) continue;
                            bl2 = false;
                            continue block4;
                        }
                    }
                    if (!bl2) {
                        StringBuffer stringBuffer = new StringBuffer(routineDesignator.name.getFullTableName());
                        stringBuffer.append("(");
                        for (n = 0; n < routineDesignator.paramTypeList.size(); ++n) {
                            if (n > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(routineDesignator.paramTypeList.get(n).toString());
                        }
                        throw StandardException.newException("42Y03", stringBuffer.toString());
                    }
                }
                routineDesignator.setAliasDescriptor(aliasDescriptor);
                tupleDescriptor = aliasDescriptor;
            }
        }
        if (tupleDescriptor != null && hashMap.get(tupleDescriptor) == null) {
            this.getCompilerContext().createDependency((Provider)((Object)tupleDescriptor));
            hashMap.put(tupleDescriptor, tupleDescriptor);
        }
        return this;
    }

    PrivilegeInfo makePrivilegeInfo() {
        switch (this.objectType) {
            case 0: {
                return this.specificPrivileges.makePrivilegeInfo();
            }
            case 1: {
                return ((RoutineDesignator)this.objectOfPrivilege).makePrivilegeInfo();
            }
        }
        return null;
    }
}

