/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.netbeans.microedition.svg.SVGLabel;
import org.netbeans.microedition.svg.input.InputHandler;
import org.netbeans.microedition.svg.input.TextInputHandler;
import org.netbeans.microedition.svg.meta.MetaData;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

public class SVGTextField
extends SVGComponent {
    protected static final String TRAIT_FONT_FAMILY = "font-family";
    protected static final String TEXT = "text";
    private static final String CARETELEM = "caret";
    protected static final String TRAIT_FONT_SIZE = "font-size";
    private static final String CARET_SUFFIX = "_caret";
    private static final String TEXT_SUFFIX = "_text";
    private static final String EDITABLE = "editable";
    private SVGLocatableElement myTextElement;
    private SVGLocatableElement myCaretElement;
    private final int elemWidth;
    private SVGLocatableElement myHiddenTextElement;
    private String myTextValue;
    private int myStartOffset = 0;
    private int myEndOffset = 0;
    private int myCaretPos = -1;
    private float caretWidth = 0.0f;
    private String myTitle;
    private boolean isReadOnly;
    private InputHandler myTextInputHandler;

    public SVGTextField(SVGForm form, SVGLocatableElement element) {
        super(form, element);
        SVGRect bBox;
        this.initNestedElements();
        this.verify();
        SVGRect outlineBox = this.getElement().getBBox();
        SVGRect textBox = this.myTextElement.getBBox();
        this.elemWidth = textBox != null ? (int)(outlineBox.getWidth() + 0.5f - (textBox.getX() - outlineBox.getX()) * 2.0f) : 0;
        this.addHiddenElement(form);
        if (this.myCaretElement != null && (bBox = this.myCaretElement.getBBox()) != null) {
            this.caretWidth = bBox.getWidth() / 2.0f;
        }
        this.setCaretPosition(0);
        this.showCaret(false);
        this.setText(this.getTextTrait());
        this.readMeta();
    }

    public SVGTextField(SVGForm form, String elemId) {
        this(form, (SVGLocatableElement)form.getDocument().getElementById(elemId));
    }

    public String getTitle() {
        SVGLabel label;
        if (this.myTitle == null && (label = this.getLabel()) != null) {
            this.setTitle(label.getText());
        }
        return this.myTitle;
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public String getText() {
        return this.myTextValue;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (!text.equals(this.myTextValue)) {
            this.myTextValue = text;
            this.setTextImpl();
            this.fireActionPerformed();
        }
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public void setStartOffset(int offset) {
        if (this.myStartOffset != offset) {
            this.myStartOffset = offset;
            this.setTextImpl();
        }
    }

    public int getCaretPosition() {
        return this.myCaretPos;
    }

    public void setCaretPosition(int caretPos) {
        if (caretPos != this.myCaretPos) {
            this.myCaretPos = caretPos;
            if (caretPos < this.myStartOffset) {
                this.setStartOffset(caretPos);
            } else if (caretPos > this.myEndOffset) {
                this.setStartOffset(this.myStartOffset + caretPos - this.myEndOffset);
            }
            if (this.myCaretElement != null) {
                float caretLoc = this.myTextElement.getFloatTrait("x");
                if (caretPos > 0) {
                    String beforeCaret = this.myTextValue.substring(this.myStartOffset, caretPos);
                    caretLoc += this.getTextWidth(beforeCaret) + this.caretWidth;
                }
                this.setTraitSafely((SVGElement)this.myCaretElement, "x", caretLoc);
            }
        }
    }

    public void setCaretVisible(boolean isVisible) {
        this.showCaret(isVisible);
    }

    public void focusGained() {
        this.showCaret(true);
    }

    public void focusLost() {
        this.showCaret(false);
    }

    public InputHandler getInputHandler() {
        if (this.myTextInputHandler != null) {
            return this.myTextInputHandler;
        }
        return this.getForm().getNumPadInputHandler();
    }

    public boolean isEditable() {
        return !this.isReadOnly;
    }

    public void setEditable(boolean editable) {
        this.isReadOnly = !editable;
        this.myTextInputHandler = this.isReadOnly ? new TextInputHandler(this.getForm().getDisplay()) : null;
    }

    private void initNestedElements() {
        if (this.getElement().getId() != null) {
            this.myTextElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + TEXT_SUFFIX);
            this.myCaretElement = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + CARET_SUFFIX);
        }
        if (this.myTextElement == null) {
            this.myTextElement = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", TEXT);
        }
        if (this.myCaretElement == null) {
            this.myCaretElement = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", CARETELEM);
        }
    }

    private void verify() {
        if (this.myTextElement == null) {
            throw new IllegalArgumentException("Element with id=" + this.getElement().getId() + " couldn't be used for Text Field." + " It doesn't have nested 'text' element. " + "See javadoc for SVG snippet format");
        }
    }

    private void showCaret(boolean showCaret) {
        if (this.myCaretElement != null) {
            this.setTraitSafely((SVGElement)this.myCaretElement, "visibility", showCaret ? "visible" : "hidden");
        }
    }

    private void addHiddenElement(SVGForm form) {
        this.myHiddenTextElement = (SVGLocatableElement)form.getDocument().createElementNS("http://www.w3.org/2000/svg", TEXT);
        this.myHiddenTextElement.setFloatTrait("x", this.myTextElement.getFloatTrait("x"));
        this.myHiddenTextElement.setFloatTrait("y", this.myTextElement.getFloatTrait("y"));
        this.myHiddenTextElement.setFloatTrait(TRAIT_FONT_SIZE, this.myTextElement.getFloatTrait(TRAIT_FONT_SIZE));
        this.myHiddenTextElement.setTrait(TRAIT_FONT_FAMILY, this.myTextElement.getTrait(TRAIT_FONT_FAMILY));
        this.myHiddenTextElement.setTrait("visibility", "hidden");
        this.getForm().invokeAndWaitSafely(new Runnable(){

            public void run() {
                SVGTextField.this.getElement().appendChild((Node)SVGTextField.this.myHiddenTextElement);
            }
        });
    }

    private void readMeta() {
        MetaData meta = new MetaData();
        meta.loadFromElement((SVGElement)this.getElement());
        String editable = (String)meta.get(EDITABLE);
        boolean bl = this.isReadOnly = !Boolean.TRUE.toString().equals(editable);
        if (this.isReadOnly) {
            this.myTextInputHandler = new TextInputHandler(this.getForm().getDisplay());
        }
    }

    private float getTextWidth(String text) {
        if (text.endsWith(" ")) {
            return this.doGetTextWidth(text + "i") - this.doGetTextWidth("i");
        }
        return this.doGetTextWidth(text);
    }

    private float doGetTextWidth(String text) {
        float width = 0.0f;
        if (text.length() > 0) {
            this.setTraitSafely((SVGElement)this.myHiddenTextElement, "#text", text);
            SVGRect bBox = this.myHiddenTextElement.getBBox();
            if (bBox != null) {
                width = bBox.getWidth();
            }
        }
        return width;
    }

    private void setTextImpl() {
        String text = this.myTextValue;
        if (this.myStartOffset > 0) {
            text = text.substring(this.myStartOffset);
        }
        while (this.getTextWidth(text) > (float)this.elemWidth) {
            text = text.substring(0, text.length() - 1);
        }
        this.setTextTrait(text);
        this.myEndOffset = this.myStartOffset + text.length();
    }

    private String getTextTrait() {
        return this.myTextElement.getTrait("#text");
    }

    private void setTextTrait(String text) {
        this.setTraitSafely((SVGElement)this.myTextElement, "#text", text);
    }
}

