/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.PerformanceData;
import com.sun.esb.management.common.data.helper.PerformanceDataMapReader;
import com.sun.esb.management.common.data.helper.PerformanceDataXMLConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceDataMapWriter
implements PerformanceDataXMLConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String FILE_NAME_KEY = "performancedatamap.xml";

    public static void writeToFile(Document document, String directoryPath) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(directoryPath);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + directoryPath + " is invalid.");
        }
        String fileLocation = file.getAbsolutePath() + File.separator + FILE_NAME_KEY;
        System.out.println("Writing out to file: " + fileLocation);
        File outputFile = new File(fileLocation);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputFile);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            aFile.createNewFile();
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static String serialize(Map<String, PerformanceData> dataMap) throws ParserConfigurationException, TransformerException {
        Document document = null;
        PerformanceDataMapWriter writer = new PerformanceDataMapWriter();
        if (dataMap != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("PerformanceMeasurementDataList");
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/PerformanceMeasurementDataList");
            root.setAttribute("version", "1.0");
            for (String category : dataMap.keySet()) {
                PerformanceData data = dataMap.get(category);
                Element performanceMeasurementDataElementChild = writer.createPerformanceMeasurementDataElement(document, data);
                root.appendChild(performanceMeasurementDataElementChild);
            }
            document.appendChild(root);
        }
        return writer.writeToString(document);
    }

    protected Element createPerformanceMeasurementDataElement(Document document, PerformanceData data) {
        Element performanceDataElement = null;
        if (document != null && data != null) {
            performanceDataElement = document.createElement("PerformanceMeasurementData");
            Element categoryElementChild = document.createElement("category");
            if (categoryElementChild != null) {
                categoryElementChild.setTextContent(data.getCategory());
            }
            performanceDataElement.appendChild(categoryElementChild);
            Element endpointElementChild = document.createElement("endpoint");
            if (endpointElementChild != null) {
                endpointElementChild.setTextContent(data.getEndpoint());
            }
            performanceDataElement.appendChild(endpointElementChild);
            Element sourceClassNameElementChild = document.createElement("sourceClassName");
            if (sourceClassNameElementChild != null) {
                sourceClassNameElementChild.setTextContent(data.getSourceClassName());
            }
            performanceDataElement.appendChild(sourceClassNameElementChild);
            Element numberOfMeasurementObjectsElementChild = document.createElement("numberOfMeasurementObjects");
            if (numberOfMeasurementObjectsElementChild != null) {
                numberOfMeasurementObjectsElementChild.setTextContent(data.getNumberOfMeasurementObjects() + "");
            }
            performanceDataElement.appendChild(numberOfMeasurementObjectsElementChild);
            Element numberOfMeasurementsElementChild = document.createElement("numberOfMeasurements");
            if (categoryElementChild != null) {
                numberOfMeasurementsElementChild.setTextContent(data.getNumberOfMeasurements() + "");
            }
            performanceDataElement.appendChild(numberOfMeasurementsElementChild);
            Element averageElementChild = document.createElement("average");
            if (averageElementChild != null) {
                averageElementChild.setTextContent(data.getAverage() + "");
            }
            performanceDataElement.appendChild(averageElementChild);
            Element averageWithoutFirstMeasurementElementChild = document.createElement("averageWithoutFirstMeasurement");
            if (averageWithoutFirstMeasurementElementChild != null) {
                averageWithoutFirstMeasurementElementChild.setTextContent(data.getAverageWithoutFirstMeasurement() + "");
            }
            performanceDataElement.appendChild(averageWithoutFirstMeasurementElementChild);
            Element firstMeasurementTimeElementChild = document.createElement("firstMeasurementTime");
            if (firstMeasurementTimeElementChild != null) {
                firstMeasurementTimeElementChild.setTextContent(data.getFirstMeasurementTime() + "");
            }
            performanceDataElement.appendChild(firstMeasurementTimeElementChild);
            Element loadElementChild = document.createElement("load");
            if (loadElementChild != null) {
                loadElementChild.setTextContent(data.getLoad() + "");
            }
            performanceDataElement.appendChild(loadElementChild);
            Element medianElementChild = document.createElement("median");
            if (medianElementChild != null) {
                medianElementChild.setTextContent(data.getMedian() + "");
            }
            performanceDataElement.appendChild(medianElementChild);
            Element throughputElementChild = document.createElement("throughput");
            if (throughputElementChild != null) {
                throughputElementChild.setTextContent(data.getThroughput() + "");
            }
            performanceDataElement.appendChild(throughputElementChild);
            Element timeTakenElementChild = document.createElement("timeTaken");
            if (timeTakenElementChild != null) {
                timeTakenElementChild.setTextContent(data.getTimeTaken() + "");
            }
            performanceDataElement.appendChild(timeTakenElementChild);
            Element totalTimeElementChild = document.createElement("totalTime");
            if (totalTimeElementChild != null) {
                totalTimeElementChild.setTextContent(data.getTotalTime() + "");
            }
            performanceDataElement.appendChild(totalTimeElementChild);
        }
        return performanceDataElement;
    }

    protected String writeToString(Document document) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/performance/PerformanceMeasurementDataList.xml";
        try {
            Map<String, PerformanceData> map = PerformanceDataMapReader.parseFromFile(uri);
            for (String category : map.keySet()) {
                System.out.println(map.get(category).getDisplayString());
            }
            String content = PerformanceDataMapWriter.serialize(map);
            System.out.println(content);
            PerformanceDataMapWriter.setContents(new File(uri), content);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

