/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.DOMUtil;
import com.sun.jbi.ui.common.ServiceAssemblyDD;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import com.sun.jbi.ui.common.Util;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceAssemblyInfo {
    public static final String XMLNS = "http://java.sun.com/xml/ns/jbi/service-assembly-info-list";
    public static final String STARTED_STATE = "Started";
    public static final String STOPPED_STATE = "Stopped";
    public static final String SHUTDOWN_STATE = "Shutdown";
    public static final String UNKNOWN_STATE = "Unknown";
    public static final String ANY_STATE = "any";
    public static final String ANY_FW_STATE = "any";
    private String mName;
    private List mSUInfoList;
    private String mDescription;
    private String mState;

    public ServiceAssemblyInfo() {
        this("", "", UNKNOWN_STATE);
    }

    public ServiceAssemblyInfo(String name, String description, String state) {
        this.mName = name;
        this.mDescription = description;
        this.mState = state;
        this.mSUInfoList = new ArrayList();
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getState() {
        return this.mState;
    }

    public void setState(String state) {
        this.mState = state;
    }

    public List getServiceUnitInfoList() {
        return this.mSUInfoList;
    }

    public String toString() {
        return "Name = " + this.getName() + "\nDescription = " + this.getDescription() + "\nState = " + this.getState() + "\nService Units = " + this.getServiceUnitInfoList().size();
    }

    public String toXmlString() {
        List suInfoList = this.getServiceUnitInfoList();
        String suInfoText = ServiceUnitInfo.writeAsXmlText(suInfoList);
        return "<service-assembly-info \nname=\"" + this.getName() + "\" \n" + "state=\"" + this.getState() + "\" >\n" + "<description>" + this.getDescription() + "</description> \n" + suInfoText + "\n" + "</service-assembly-info>";
    }

    public static ServiceAssemblyInfo createServiceAssemblyInfo(Element saInfoEl) {
        ServiceAssemblyInfo info = new ServiceAssemblyInfo();
        String name = saInfoEl.getAttribute("name");
        String state = saInfoEl.getAttribute("state");
        info.setName(name);
        info.setState(state);
        String desc = null;
        Element descEl = DOMUtil.UTIL.getChildElement(saInfoEl, "description");
        if (descEl != null) {
            desc = DOMUtil.UTIL.getTextData(descEl);
        }
        info.setDescription(desc);
        NodeList suInfoElList = DOMUtil.UTIL.getChildElements(saInfoEl, "service-unit-info");
        List list = ServiceUnitInfo.createServiceUnitInfoList(suInfoElList);
        info.getServiceUnitInfoList().addAll(list);
        return info;
    }

    public static List createServiceAssemblyInfoList(Element saInfoListEl) {
        ArrayList<ServiceAssemblyInfo> saInfoList = new ArrayList<ServiceAssemblyInfo>();
        if (saInfoListEl == null) {
            return saInfoList;
        }
        String version = saInfoListEl.getAttribute("version");
        NodeList saInfoNodeList = DOMUtil.UTIL.getChildElements(saInfoListEl, "service-assembly-info");
        int size = saInfoNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element saInfoEl = (Element)saInfoNodeList.item(i);
            if (saInfoEl == null) continue;
            ServiceAssemblyInfo saInfo = ServiceAssemblyInfo.createServiceAssemblyInfo(saInfoEl);
            saInfoList.add(saInfo);
        }
        ServiceAssemblyInfo.sort(saInfoList);
        return saInfoList;
    }

    public static List readFromXmlTextWithProlog(Reader xmlReader) {
        ArrayList saInfoList = new ArrayList();
        Document xmlDoc = null;
        try {
            xmlDoc = DOMUtil.UTIL.buildDOMDocument(xmlReader);
        }
        catch (Exception ex) {
            Util.logDebug(ex);
        }
        if (xmlDoc == null) {
            return saInfoList;
        }
        Element saInfoListEl = DOMUtil.UTIL.getElement(xmlDoc, "service-assembly-info-list");
        if (saInfoListEl == null) {
            return saInfoList;
        }
        return ServiceAssemblyInfo.createServiceAssemblyInfoList(saInfoListEl);
    }

    public static List readFromXmlTextWithProlog(String xmlText) {
        return ServiceAssemblyInfo.readFromXmlTextWithProlog(new StringReader(xmlText));
    }

    public static String writeAsXmlText(List saInfoList) {
        ServiceAssemblyInfo.sort(saInfoList);
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter, true);
        writer.println("<service-assembly-info-list  version=\"1.0\"  xmlns=\"http://java.sun.com/xml/ns/jbi/service-assembly-info-list\"  >");
        int size = saInfoList.size();
        for (int i = 0; i < size; ++i) {
            ServiceAssemblyInfo info = (ServiceAssemblyInfo)saInfoList.get(i);
            writer.println(info.toXmlString());
        }
        writer.println("</service-assembly-info-list>");
        try {
            writer.close();
            stringWriter.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public static String writeAsXmlTextWithProlog(List saInfoList) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("\n");
        buffer.append(ServiceAssemblyInfo.writeAsXmlText(saInfoList));
        buffer.append("\n");
        return buffer.toString();
    }

    public static ServiceAssemblyInfo createFromServiceAssemblyDD(ServiceAssemblyDD saDD) {
        ServiceAssemblyInfo saInfo = new ServiceAssemblyInfo();
        saInfo.setName(saDD.getName());
        saInfo.setDescription(saDD.getDescription());
        List suDDList = saDD.getServiceUnitDDList();
        ArrayList<ServiceUnitInfo> suInfoList = new ArrayList<ServiceUnitInfo>();
        Iterator itr = suDDList.iterator();
        while (itr.hasNext()) {
            ServiceUnitInfo suInfo = ServiceUnitInfo.createFromServiceUnitDD((ServiceAssemblyDD.ServiceUnitDD)itr.next());
            suInfoList.add(suInfo);
        }
        saInfo.getServiceUnitInfoList().addAll(suInfoList);
        return saInfo;
    }

    public static ServiceAssemblyInfo createFromServiceAssemblyDD(Reader jbiXmlReader) {
        try {
            ServiceAssemblyDD dd = (ServiceAssemblyDD)ServiceAssemblyDD.createJBIDescriptor(jbiXmlReader);
            if (dd != null) {
                return ServiceAssemblyInfo.createFromServiceAssemblyDD(dd);
            }
        }
        catch (Exception ex) {
            Util.logDebug(ex);
        }
        return null;
    }

    public static void sort(List saInfoList) {
        try {
            Collections.sort(saInfoList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((ServiceAssemblyInfo)o1).getName().compareTo(((ServiceAssemblyInfo)o2).getName());
                }
            });
        }
        catch (ClassCastException ccEx) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

