/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.security;

import net.java.bd.tools.security.SecurityUtil;

public class BDCertGenerator {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            BDCertGenerator.printUsageAndExit("Please enter an orgid");
        }
        SecurityUtil.Builder builder = new SecurityUtil.Builder();
        boolean setOrgId = false;
        boolean setCertType = false;
        for (int i = 0; i < args.length; ++i) {
            String opt = args[i];
            if (opt.equals("-keystore")) {
                if (++i == args.length) {
                    BDCertGenerator.errorNeedArgument(opt);
                }
                builder = builder.keystoreFile(args[i]);
                continue;
            }
            if (opt.equals("-root")) {
                builder = builder.setRootCert();
                setCertType = true;
                continue;
            }
            if (opt.equals("-app")) {
                builder = builder.setAppCert();
                setCertType = true;
                continue;
            }
            if (opt.equals("-binding")) {
                builder = builder.setBindingUnitCert();
                setCertType = true;
                continue;
            }
            if (opt.equals("-dn")) {
                if (++i == args.length) {
                    BDCertGenerator.errorNeedArgument(opt);
                }
                builder = builder.dn(args[i]);
                continue;
            }
            if (opt.equals("-altname")) {
                if (++i == args.length) {
                    BDCertGenerator.errorNeedArgument(opt);
                }
                builder = builder.altName(args[i]);
                continue;
            }
            if (opt.equals("-alias")) {
                if (++i == args.length) {
                    BDCertGenerator.errorNeedArgument(opt);
                }
                builder = builder.newCertAlias(args[i]);
                continue;
            }
            if (opt.equals("-signeralias")) {
                if (++i == args.length) {
                    BDCertGenerator.errorNeedArgument(opt);
                }
                builder = builder.certSignerAlias(args[i]);
                continue;
            }
            if (opt.equals("-help")) {
                BDCertGenerator.printUsageAndExit("");
                continue;
            }
            if (opt.equals("-debug")) {
                builder = builder.debug();
                continue;
            }
            if (args[i].length() != 8) {
                BDCertGenerator.printUsageAndExit("Bad OrgID " + args[i] + ", please provide an 8 digit hex.");
            }
            builder = builder.orgId(args[i]);
            setOrgId = true;
        }
        if (!setOrgId) {
            BDCertGenerator.printUsageAndExit("Please enter an orgid");
        }
        if (!setCertType) {
            BDCertGenerator.printUsageAndExit("Please enter type of the certificate to generate:root/app/binding");
        }
        SecurityUtil util = builder.build();
        util.createCerts();
    }

    private static void tinyHelp() {
        System.err.println("Try BDCertGenerator -help");
        System.exit(1);
    }

    private static void errorNeedArgument(String flag) {
        System.err.println("Command option <flag> needs an argument.");
        BDCertGenerator.tinyHelp();
    }

    private static void printUsageAndExit(String reason) {
        if (!reason.isEmpty()) {
            System.err.println("\nFailed: " + reason + "\n");
        }
        System.err.println("***This tool generates keystore/certificates for securing BD-J applications***\n");
        System.err.println("usage: BDCertGenerator [options] cert_type organization_id\n");
        System.err.println("Valid Options:");
        System.err.println(" -root|-app|-binding  \t:Type of the Certificate");
        System.err.println(" -keystore    filename\t:Create a keystore file with the given filename");
        System.err.println(" -dn          name    \t:Distinguished name of the certificate");
        System.err.println("                      \t Note: The organization_id is appended to the org name");
        System.err.println("                      \t component of the dn");
        System.err.println(" -altname     name    \t:Subject alternate name for the certificate");
        System.err.println(" -alias       name    \t:The keystore alias for the newly generated certificate");
        System.err.println(" -signeralias name    \t:The certificate signer alias for the application certificate");
        System.err.println(" -debug               \t:Prints debug messages");
        System.err.println(" -help                \t:Prints this message");
        System.err.println("\nExample: java -cp security.jar:tools.jar:bcprov-jdk15-137.jar net.java.bd.tools.security.BDCertGenerator -root 56789abc \n");
        System.exit(1);
    }
}

