/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.security;

import java.io.IOException;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509NameEntryConverter;

public class X509BDJEntryConverter
extends X509NameEntryConverter {
    public DERObject getConvertedValue(DERObjectIdentifier oid, String value) {
        if (value.length() != 0 && value.charAt(0) == '#') {
            try {
                return this.convertHexEncoded(value, 1);
            }
            catch (IOException e) {
                throw new RuntimeException("can't recode value for oid " + oid.getId());
            }
        }
        if (oid.equals((Object)X509Name.EmailAddress) || oid.equals((Object)X509Name.DC)) {
            return new DERIA5String(value);
        }
        if (oid.equals((Object)X509Name.DATE_OF_BIRTH)) {
            return new DERGeneralizedTime(value);
        }
        if (oid.equals((Object)X509Name.SN) || oid.equals((Object)X509Name.DN_QUALIFIER)) {
            return new DERPrintableString(value);
        }
        return new DERUTF8String(value);
    }
}

